package com.zjty.inspect.utils;

import com.zjty.inspect.entity.TechnologyContent;
import freemarker.template.Configuration;
import freemarker.template.Template;

import java.io.*;
import java.util.List;
import java.util.Map;

public class FreeMakerUtils {

        public static String parseTpl(String viewName, Map params) {
            Configuration cfg = SpringContextHolder.getBean(Configuration.class);
            Template t = null;
            try {
                t = cfg.getTemplate(viewName + ".ftl");
                String word = createWord(t, params);
                return "/doc/"+word;
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
        public static String createWord(Template template, Map<String, List<TechnologyContent>> dataMap){
            try {
                //文件路径
                String filePath= "./ins/doc/";

                //文件名称
                String fileName = System.currentTimeMillis()+".doc";
                // 输出文件
                File outFile = new File(filePath + File.separator + fileName);

                // 如果输出目标文件夹不存在，则创建
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }

                // 将模板和数据模型合并生成文件
                Writer out = new BufferedWriter(new OutputStreamWriter(
                        new FileOutputStream(outFile), "UTF-8"));

                // 生成文件
                template.process(dataMap, out);
                // 关闭流
                out.flush();
                out.close();
                return fileName;
            }catch (Exception e){
                e.printStackTrace();
            }
            return null;

        }
    public static void writeFile(String file, String conent) {
        // Log4jBean.logger.info("开始以追加的形式写文件到：["+file+"]");
        BufferedWriter out = null;
        try {
            File outFile = new File(file);

            // 如果输出目标文件夹不存在，则创建
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile, false)));
            out.write(conent);
            // Log4jBean.logger.info("写文件:["+file+"]完成");
        } catch (Exception e) {
            // Log4jBean.logger.error("写文件:["+file+"]异常，异常信息为:["+e.getMessage()+"]");
        } finally {
            // Log4jBean.logger.info("开始关闭输出流");
            try {
                out.close();
            } catch (IOException e) {
                // Log4jBean.logger.info("关闭输出流异常，异常信息为:["+e.getMessage()+"]");
            }
        }
    }
    public static void createStringTemplate(Map map,String template){
        try {
            //文件路径
            String filePath= "E://doc";

            //文件名称
            String fileName = System.currentTimeMillis()+".doc";
            // 输出文件
            File outFile = new File(filePath + File.separator + fileName);

            // 如果输出目标文件夹不存在，则创建
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }

            // 将模板和数据模型合并生成文件
            Writer out = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(outFile), "UTF-8"));
            Template t = new Template("template", new StringReader(template), new Configuration(Configuration.VERSION_2_3_23));
            t.process(map,out);
            // 关闭流
            out.flush();
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
