package com.zjty.inspect.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum RtoEnum {
    YI(0,"1-60秒"),
    //平滑过渡
    SHI(1,"10分钟内"),
    SAN(2,"30分钟内"),
    LIU(3,"60分钟内"),
    Y(4,"1-5小时"),
    WU(5,"5-10小时"),
    ERS(6,"24小时内"),
    SIB(7,"48小时内"),
    //暂停服务
    QI(8,"72小时内"),
    //休息日或晚间替换
    ZH(9,"一周内");

    private Integer code;
    private String name;

    RtoEnum() {
    }
    private static Map<String,RtoEnum> rtoEnumHashMap=new HashMap<>();
    private static Map<Integer,RtoEnum> rtoCodeEnumHashMap=new HashMap<>();

    static {
        for (RtoEnum rtoEnum : RtoEnum.values()) {
            rtoEnumHashMap.put(rtoEnum.getName(),rtoEnum);
            rtoCodeEnumHashMap.put(rtoEnum.getCode(),rtoEnum);
        }
    }
    public static RtoEnum getByName(String name){
        RtoEnum rpoEnum = rtoEnumHashMap.get(name);
        return rpoEnum;
    }
    public static RtoEnum getByCode(Integer code){
        RtoEnum rpoEnum = rtoEnumHashMap.get(code);
        return rpoEnum;
    }
    RtoEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

}
