package com.zjty.inspect.thread.task;

import com.zjty.inspect.config.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class AsyncTask {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private WebSocketServer webSocketServer;

    /**
    * @Description: myTaskAsynPool即配置线程池的方法名，
     *  此处如果不写自定义线程池的方法名，会使用默认的线程池
    * @Param:
    * @return:
    * @Author: LiuJie
    * @Date: 2019/5/20
    */
    @Async("myTaskAsyncPool")
    public void sendMessageToAll(Map<String,String> map) throws Exception{
        webSocketServer.sendMessageToAll(map);
    }

}