package com.zjty.inspect.controller;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.service.InspectService;
import com.zjty.inspect.utils.FileUtil;
import com.zjty.inspect.utils.MavenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;

/**
 * 评估接口
 * @author mcj
 */
@RestController
@RequestMapping("/inspect")
public class InspectController {
    @Autowired
    private InspectService inspectService;


    /**
     * 上传代码进行评估
     * @param inspectParameter
     * @return
     */
    @PostMapping("/path")
    public ResponseEntity inspect(@RequestBody InspectParameter inspectParameter, MultipartFile file) throws IOException {
        File file1 = file.getResource().getFile();
        if(file1.getName().endsWith("zip")){
            FileUtil.unPackZip(file1,"", "./");
        }else{
            FileUtil.unPackRar(file1, "./");
        }
        String[] split = file1.getName().split("\\.");
        File file2 = new File("./"+split[0]);
        String path1 = file2.getPath();
        //File file1 = new File("/Users/mcj/IdeaProjects/inspect");
        //String path1 = file1.getPath();
        inspectService.inspect(inspectParameter,path1);
        return ResponseEntity.ok(200);
    }

    /**
     * git下载代码进行评估
     * @param path
     * @return
     */
    @PostMapping("/git")
    public ResponseEntity inspect1(@RequestBody InspectParameter inspectParameter,String path){

        inspectService.inspect(inspectParameter,path);
        System.out.println(path);
        return ResponseEntity.ok(200);
    }


}
