package com.zjty.inspect.controller;

import com.zjty.inspect.entity.Pages;
import com.zjty.inspect.service.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * 报告
 *
 * @author Mcj
 * @date 2020-02-27 09:58
 */
@RequestMapping("/report")
@RestController
public class ReportController {

    @Autowired
    private ReportService reportService;

    /**
     * 历史报告查看
     *
     * @return 历史报告
     */
    @GetMapping
    public ResponseEntity history() {
        return ResponseEntity.ok(reportService.getHistory());
    }

    /**
     * 历史报告查看
     *
     * @return 历史报告
     */
    @PostMapping
    public ResponseEntity history(@RequestBody Pages pages) {
        return ResponseEntity.ok(reportService.getHistory(pages.getPage()));
    }

    /**
     * 历史报告查看
     *
     * @return 历史报告
     */
    @GetMapping("/{id}")
    public ResponseEntity getHistory(@PathVariable String id) {
        return ResponseEntity.ok(reportService.getHistory(id));
    }
    /**
     * 历史报告删除
     *
     * @return 历史报告
     */
    @DeleteMapping
    public ResponseEntity remove(String id) {
        reportService.remove(id);
        return ResponseEntity.ok(200);
    }
}
