package com.zjty.inspect.dao;

import com.zjty.inspect.entity.Budget;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

/**
 *
 * 预算
 * @author mcj
 */
public interface BudgetDao extends JpaRepository<Budget,String> {

    /**
     * 根据报告id查询预算
     * @param id 报告id
     * @return
     */
    List<Budget> findAllByReportIdEquals(String id);

    /**
     * 根据报告id删除
     * @param id 报告id
     */
    void deleteByReportIdEquals(String id);
}
