package com.zjty.inspect.dao;

import com.zjty.inspect.entity.TechnologyAndReport;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

/**
 * 报告与适配技术中间表
 * @author mcj
 */
public interface TechnologyAndReportDao extends JpaRepository<TechnologyAndReport,String> {

    /**
     * 根据报告id查询规则
     * @param id 报告id
     * @return list
     */
    List<TechnologyAndReport> findAllByReportIdEquals(String id);

    /**
     * 根据报告id删除
     * @param id 报告id
     */
    void deleteByReportIdEquals(String id);
}
