package com.zjty.inspect.service;

import com.zjty.inspect.entity.ReportVo;
import org.springframework.data.domain.Page;

import java.util.List;

public interface ReportService {
    /**
     * 获取历史报告数量。页码等
     * @param page 页码
     * @return 历史报告
     */
    public List<ReportVo> getHistory(int page);

    /**
     * 获取所有历史报告
     * @return 历史报告
     */
    public Page getHistory();

    /**
     * 根据报告id查询
     * @param id 报告id
     * @return 历史报告
     */
    public ReportVo getHistory(String id);

    /**
     * 根据id删除数据
     * @param id 报告id
     */
    void remove(String id);
}
