package com.zjty.inspect.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zjty.inspect.dao.BudgetDao;
import com.zjty.inspect.dao.ReportDao;
import com.zjty.inspect.dao.TechnologyAndReportDao;
import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.service.ReportService;
import com.zjty.inspect.utils.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author Mcj
 * @date 2020-02-27 10:35
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ReportServiceImpl implements ReportService {

    @Autowired
    private ReportDao reportDao;

    @Autowired
    private TechnologyDao technologyDao;
    @Autowired
    private TechnologyAndReportDao technologyAndReportDao;

    @Autowired
    private BudgetDao budgetDao;

    @Autowired
    private RedisUtil redisUtil;

    @Override
    public List<ReportVo> getHistory(int page) {
        ArrayList<ReportVo> reportVos = new ArrayList<>();
        PageRequest pageRequest = PageRequest.of(page - 1,10);
        Page<Report> all = reportDao.findAll(pageRequest);
        for (Report report : all.getContent()) {
            ReportVo reportVo = set(report);
            reportVos.add(reportVo);
        }
        return reportVos;
    }

    @Override
    public Page getHistory() {
        PageRequest pageRequest = PageRequest.of(1,10);
        Page<Report> all = reportDao.findAll(pageRequest);
        return all;
    }

    @Override
    public ReportVo getHistory(String id) {
        Optional<Report> byId = reportDao.findById(id);
        if(byId.isPresent()){
            return set(byId.get());
        }
        return new ReportVo();
    }

    @Override
    @Modifying
    public void remove(String id) {
        reportDao.deleteById(id);
        budgetDao.deleteByReportIdEquals(id);
        technologyAndReportDao.deleteByReportIdEquals(id);
    }

    public ReportVo set(Report report){
        ReportVo reportVo = new ReportVo();
        reportVo.setId(report.getId());
        reportVo.setManager(report.getManager());
        reportVo.setLanguage(report.getLanguage());
        reportVo.setFramework(report.getFramework());
        reportVo.setRecastMethod(report.getRecastMethod());
        reportVo.setHtmlAddress(report.getHtmlAddress());
        // TODO: 2020-02-27 从redis中查询依赖树
        Object o = redisUtil.get(report.getId());
        if(o!=null){
            reportVo.setDepTreeVo((DepTreeVo) o);
        }

        HashSet<String> num = new HashSet<>();
        List<TechnologyAndReport> rar = technologyAndReportDao.findAllByReportIdEquals(report.getId());
        ArrayList<TechnologyVo> technologyVos = new ArrayList<>();
        HashMap<String, ArrayList<RuleAndReportVo>> map = new HashMap<>();
        for (TechnologyAndReport technologyAndReport : rar) {
            num.add(technologyAndReport.getTechnologyId());
            if (map.containsKey(technologyAndReport.getTechnologyId())) {
                RuleAndReportVo ruleAndReportVo = new RuleAndReportVo();
                ruleAndReportVo.setFilePath(technologyAndReport.getFilePath());
                ruleAndReportVo.setLineNum(technologyAndReport.getLineNum());
                map.get(technologyAndReport.getTechnologyId()).add(ruleAndReportVo);
            } else {
                RuleAndReportVo ruleAndReportVo = new RuleAndReportVo();
                ruleAndReportVo.setFilePath(technologyAndReport.getFilePath());
                ruleAndReportVo.setLineNum(technologyAndReport.getLineNum());
                map.put(technologyAndReport.getTechnologyId(), new ArrayList<>());
                map.get(technologyAndReport.getTechnologyId()).add(ruleAndReportVo);
            }
        }
        Set<String> strings = map.keySet();
        ArrayList<String> strings1 = new ArrayList<>(strings);
        for (String id : strings) {
            Optional<Technology> byId = technologyDao.findById(id);
            if (byId.isPresent()) {
                Technology technology = byId.get();
                String technologyName = technology.getTechnologyName();
                map.put(technologyName, map.get(id));
                TechnologyVo technologyVo = new TechnologyVo();
                technologyVo.setAdvice(technology.getAdvice());
                technologyVo.setTechnologyName(technology.getTechnologyName());
                technologyVo.setFund(technology.getFund());
                technologyVos.add(technologyVo);
            }
        }
        List<Budget> budgetList = budgetDao.findAllByReportIdEquals(report.getId());
        for (String s : strings1) {
            map.remove(s);
        }

        reportVo.setBudgets(budgetList);
        reportVo.setWarnDetails(map);
        reportVo.setTechnologyVos(technologyVos);
        reportVo.setWarnNum(num.size());
        return reportVo;
    }
}
