package com.zjty.inspect.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.Column;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * @author Mcj
 */
@Data
public class ReportVo {

    private String id;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 上传类型
     */
    private String uploadType;
    /**
     * git源代码地址
     */
    private String gitAddress;

    /**
     * 架构，整合型还是分离型，根据jsp数量决定
     */
    private Integer framework;

    /**
     * 代码管理方式，
     */
    private Integer manager;

    /**
     * 数据库类型
     */
    private String databaseType;

    /**
     * 语言
     */
    private Integer language;

    /**
     * 生成报告存储地址
     */
    private String htmlAddress;

    /**
     * 适配方式
     * 1：适配或者修改
     * 2：重构
     */
    private Integer recastMethod;

    /**
     * 源代码地址
     */
    private String sourceAddress;

    /**
     * 预算详情
     */
    private BudgetVo budgets;

    /**
     * 依赖
     */
    private DependencyVo dependencyVo;

    /**
     * 匹配技术列表
     */
    private List<Technology> technologies;

    /**
     * 告警点
     */
    private HashMap<String, List<Warn>> warnDetails;

    /**
     * 关键技术个数
     */
    private Integer technologiesNum;

    /**
     * 需要改造的技术
     */
    private Integer technologiesRepair;


    /**
     * 评估时间
     */
    @JsonFormat(pattern = "YYYY-MM-dd",timezone="GMT+8")
    private Date createDate = new Date();
}
