<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>应用系统评估详情</title>
    <style>
        .detailContent {
            background: #f9f9f9;
            height: 800px;
        }
        .detailContentT {
            color: #333;
            font-size: 28px;
            text-align: center;
            padding: 20px 0;
        }
        .systemName {
            height: 215px;
            background: #fff;
            margin: 0 30px 20px;
        }
        .systemName>img {
            margin: 20px 10px -2px 20px;
        }
        .keyTec {
            height: 380px;
            background: #fff;
            margin: 0 30px;
        }
        .nav-title {
            color: #333;
            font-size: 22px;
            display: inline-block;
        }
        .nav-time {
            float: right;
            color: #333;
            font-size: 22px;
            margin: 20px;
        }
        .clearfloat {
            clear: both
        }
        .line {
            height: 2px;
            background: rgba(72,156,239,.3);
            margin: 0 30px;
        }
        .systemNameCon {
            display: flex;
            justify-content: space-around;
            align-items: center;
            margin: 20px 0 20px 30px;
        }
        .systemNameCon>div {
            color: #666;
            font-size: 18px;
            width: 250px;
        }
        .systemNameCon>div>span {
            color: #333;
            font-size: 18px;
        }
        /*keyTec*/
        .first>div>img,.second>div>img,.third>div>img {
            margin: 20px 10px -2px 20px;
        }
        .first-title {
            margin-bottom: 10px;
            position: relative;
        }
        .rightPic {
            position: absolute;
            right: 40px;
            top: 30px;
        }

        .key-title {
            color: #d32d2d;
        }
        .keySecond-title {
            color: #3bb21f;
        }
        .keyThird-title {
            color: #666;
        }
        table{
            width: 100%;
        }
        td{
            text-align: center;
            height: 30px;
        }
        tr td {
            color: #d32d2d;
        }
        tr:last-child td {
            border-bottom: 1px dashed rgba(72,156,239,.3);
        }
        th {
            border-bottom: 1px dashed rgba(72,156,239,.3);
        }
        .onAnaly {
            margin: 0 30px;
            text-align: right;
        }
        .onAonAnalysis {
            display: inline-block;
            color: #666;
            padding-right: 20px;
        }
        .onAonAnalysis>span {
            color: #333;
        }

        .className {
            transform:rotate(180deg);
        }
    </style>
</head>
<body>
<div class="detailContent">
    <p class="detailContentT">应用系统信创评估详情</p>
    <div class="systemName">
        <img src="./img/system.png" alt="">
        <div class="nav-title">系统名称：<span>${projectName}</span></div>
        <div class="nav-time">评估时间：<span>${createDate}</span></div>
        <div class="clearfloat"></div>
        <div class="line"></div>
        <div class="systemNameCon">
            <div>编号：<span>${createDate}</span></div>
            <div>上传类型：<span>${uploadType}</span></div>
            <div>文件名：<span>${fileName}</span></div>
            <div>架构：<span>${framework}</span></div>
        </div>
        <div class="systemNameCon">
            <div>数据库类型：<span>${databaseType}</span></div>
            <div>依赖管理工具：<span>${manager}</span></div>
            <div>语言： <span>${language}</span></div>
            <div></div>
        </div>
        <div class="systemNameCon">

        </div>

    </div>
    <div class="keyTec">
        <#if warnDetails??>
            <#list warnDetails as warn>
                <div class="first">
            <div class="first-title">
                <img src="./img/key.png" alt="">
                <div  class="nav-title key-title">关键技术：<span>${warn.}Java依赖(支持国产化)</span> <span>需替换</span> </div>
                <div  class="rightPic">
                    <img onclick="showDiv()" id="pic" src="./img/down.png" alt="">
                </div>
            </div>

            <div class="line"></div>
            <div id="slider" style="margin: 0 100px">
                <table>
                    <tr>
                        <th>关键字</th>
                        <th>所在文件</th>
                        <th>行数</th>
                    </tr>
                    <tr>
                        <td>mysql</td>
                        <td>pp.xl</td>
                        <td>100</td>
                    </tr>
                    <tr>
                        <td>mysql</td>
                        <td>pp.xl</td>
                        <td>100</td>
                    </tr>
                    <tr>
                        <td>mysql</td>
                        <td>pp.xl</td>
                        <td>100</td>
                    </tr>
                </table>
            </div>
        </div>
            </#list>
        </#if>
        <div class="second">
            <div class="first-title">
                <img src="./img/key.png" alt="">
                <div  class="nav-title keySecond-title">关键技术：<span>Java依赖(支持国产化)</span> <span>无需替换</span> </div>
                <div  class="rightPic">
                    <img id="pic1" onclick="showDiv1()" src="./img/down.png" alt="">
                </div>
            </div>
            <div class="line"></div>
            <div id="secondClick">
            </div>

        </div>
        <div class="third">
            <div class="first-title">
                <img src="./img/key.png" alt="">
                <div  class="nav-title keyThird-title">关键技术：<span>Java依赖(支持国产化)</span> <span>未知</span> </div>
                <div  class="rightPic ">
                    <img id="pic2"  onclick="showDiv2()" src="./img/down.png" alt="">
                </div>
            </div>
            <div class="line"></div>

            <div class="onAnaly" id="thirdClick">
                <div class="onAonAnalysis">关键技术总共：<span>1000</span></div>
                <div class="onAonAnalysis">需要改造的关键技术：<span>1000</span></div>
                <div class="onAonAnalysis">泰源系统安可改造评估引擎：<span>版本号：10.6.9</span></div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function showDiv(){
        var slider=document.getElementById("slider");
        slider.style.display = slider.style.display=="none"?"":"none";
        if(slider.style.display == "none") {
            document.getElementById("pic").classList.add("className")
        }else {
            document.getElementById("pic").classList.remove("className")
        }
    }
    function showDiv1(){
        var secondClick=document.getElementById("secondClick");
        secondClick.style.display = secondClick.style.display=="none"?"":"none";
        if(secondClick.style.display == "none") {
            document.getElementById("pic1").classList.add("className")
        }else {
            document.getElementById("pic1").classList.remove("className")
        }
    }
    function showDiv2(){
        var thirdClick=document.getElementById("thirdClick");
        thirdClick.style.display = thirdClick.style.display=="none"?"":"none";
        if(thirdClick.style.display == "none") {
            document.getElementById("pic2").classList.add("className")
        }else {
            document.getElementById("pic2").classList.remove("className")
        }
    }
</script>
</body>
</html>