package com.zjty.inspect.controller;

import com.zjty.inspect.entity.InspectParameter;
import com.zjty.inspect.service.ParameterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author Mcj
 * @date 2020-03-03 11:00
 */
@RestController
@RequestMapping("/param")
@Api(value = "参数页面管理接口",description = "参数页面管理接口,提供页面的增、删、改、查")
public class ParamController {

    @Autowired
    private ParameterService parameterService;

    @GetMapping
    @ApiOperation("获取参数")
    public ResponseEntity getParam(String id){
        return ResponseEntity.ok(parameterService.getParameterById(id));
    }

    @PostMapping
    @ApiOperation("保存参数")
    public ResponseEntity saveParam(@RequestBody InspectParameter inspectParameter){
        parameterService.saveParameter(inspectParameter);
        return ResponseEntity.ok(200);
    }

}
