package com.zjty.inspect.config;

import com.zjty.inspect.aop.AuthIntercept;
import com.zjty.inspect.entity.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Mcj
 * @date 2020-04-02 14:42
 */
@Configuration
public class LoginInterceptor implements HandlerInterceptor {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private AuthIntercept authIntercept;
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        String sessionId = request.getHeader("sessionId");
        String url = "http://120.55.57.35:12345/user/getLogin/"+sessionId;
        ServerResponse user = restTemplate.getForObject(url, ServerResponse.class);
        if(user==null){
            //不符合条件的给出提示信息，并转发到登录页面
            request.setAttribute("msg", "您还没有登录，请先登录！");
            response.setStatus(403);
            return false;
        }
        authIntercept.setUser(user.getData());
        return true;
    }

    @Bean
    public RestTemplate restTemplate(){
        return new RestTemplate();
    }
}
