package com.zjty.inspect.utils;

import com.zjty.inspect.dao.CoefficientModelDao;
import com.zjty.inspect.entity.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 获取预算
 * @author Mcj
 * @date 2020-02-26 15:14
 */

@Component
public class BudgetUitl {


    @Autowired
    private CoefficientModelDao coefficientModelDao;

    /**
     * 获取预算数据
     * @param fund 技术费用
     * @param report
     * @param inspectParameter  计算所需数据
     * @return
     */
    public BudgetVo getBudget(Integer fund, ReportVo report, InspectParameter inspectParameter){
        BudgetVo budgetVo = new BudgetVo();

        // TODO: 2020-03-05 查询年复利率
        inspectParameter.setMoneyRate(1.04);

        //代码重构比
        double refactorProportion = 0D;
        //代码修改比
        double updateProportion = 0D;
        if(report.getRecastMethod()==1){
            inspectParameter.setProportion(0.6);
        }else{
            // TODO: 2020-03-05 查询config表0.3或者0.15
            inspectParameter.setProportion(0.3);
        }
        int scale;
        Integer systemFund = inspectParameter.getSystemFund();
        if(systemFund==0){
            double v = inspectParameter.getModules() * 7.5;
            systemFund= (int) v;
        }
        if(systemFund<30){
            scale=1;
        }else if(systemFund<200){
            scale=2;
        }else{
            scale=3;
        }

        Double moneyRate = inspectParameter.getMoneyRate();
        int years = inspectParameter.getYears();
        double pow = Math.pow(moneyRate, years);

        //带修正系数资金
        ArrayList<String> strings = new ArrayList<>();
        strings.add("安全能力");
        strings.add("容灾能力");
        strings.add("架构");
        strings.add("数据量");
        strings.add("模块数");
        strings.add("数据库表");
        strings.add("代码量");
        double coefficient = 1;
        List<CoefficientModel> nameIn = coefficientModelDao.findAllByNameIn(strings);
        List<CoefficientModel> collect = nameIn.stream().filter(a -> a.getScale() == scale).collect(Collectors.toList());
        for (CoefficientModel model : collect) {
            CoefficientModelVo coefficientModelVo = new CoefficientModelVo();
            coefficientModelVo.setName(model.getName());
            if("架构".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getFramework());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }else if("容灾能力".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getDisaster());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("安全能力".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getSafety());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("数据量".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getData());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("模块数".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getModules());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("数据库表".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getTables());
                coefficientModelVo.setValue(value);
                coefficient *=value;
            }
            else if("代码量".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getCodeSize());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            budgetVo.getCoefficientModelVos().add(coefficientModelVo);
        }
        Budget codeRefactor = new Budget();
        codeRefactor.setBudgetName("代码重构预算");
        //不带修正系数资金
        double fundNotRepair = inspectParameter.getProportion() * pow * systemFund + fund;
        double fundRepair=fundNotRepair*coefficient;
        if(fundNotRepair<fundRepair){
            codeRefactor.setFund(fundNotRepair +"--"+fundRepair);
        }else if(fundNotRepair>fundRepair){
            codeRefactor.setFund(fundRepair +"--"+fundNotRepair);
        }else{
            codeRefactor.setFund(fundRepair +"--"+fundNotRepair);
        }
        codeRefactor.setFundDetail("普通业务开发费用:"+fundNotRepair);
        codeRefactor.setFundDetail("普通业务开发费用(修正):"+fundRepair);
        codeRefactor.setFundDetail("关键适配技术成本:"+fund);

        Budget codeUpdate = new Budget();
        codeUpdate.setBudgetName("代码修改替换预算");
        double findUpdateNotRepair = inspectParameter.getProportion() * pow * systemFund + fund;
        double findUpdateRepair = findUpdateNotRepair * coefficient;


        if(findUpdateNotRepair<findUpdateRepair){
            codeUpdate.setFund(findUpdateNotRepair +"--"+findUpdateRepair);
        }else if(fundNotRepair>fundRepair){
            codeUpdate.setFund(findUpdateRepair +"--"+findUpdateNotRepair);
        }else{
            codeUpdate.setFund(findUpdateRepair +"--"+findUpdateNotRepair);
        }
        codeUpdate.setFundDetail("普通业务开发费用:"+findUpdateNotRepair);
        codeUpdate.setFundDetail("普通业务开发费用(修正):"+findUpdateRepair);
        codeUpdate.setFundDetail("关键适配技术成本:"+fund);

        budgetVo.getBudget().add(codeRefactor);
        budgetVo.getBudget().add(codeUpdate);

        return budgetVo;
    }
}
