package com.zjty.inspect.controller;

import com.zjty.inspect.aop.AuthAnnotation;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.service.TechnologyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 适配技术
 * @author Mcj
 * @date 2020-02-29 16:10
 */

@RequestMapping("/technology")
@RestController
@Api(value = "适配技术页面管理接口",description = "适配技术页面管理接口,提供页面的增、删、改、查")
public class TechnologyController {

    @Autowired
    private TechnologyService technologyService;

    /**
     * 获取所有关键技术
     * @return List
     */
    @GetMapping
    @ApiOperation("获取所有关键技术")
    public ResponseEntity getTechnologies(){
        return ResponseEntity.ok(technologyService.findAllTechnology());
    }
    @GetMapping("/names")
    @ApiOperation("获取所有关键技术name")
    @AuthAnnotation(code = {"001100"})
    public ResponseEntity getTechnologiesName(){
        return ResponseEntity.ok(technologyService.findAllTechnologyNames());
    }

    /**
     * 获取所有关键技术
     * @return List
     */
    @GetMapping(value = "/{name}")
    @ApiOperation("根据name获取所有关键技术")
    @AuthAnnotation(code = {"001100"})
    public ResponseEntity getTechnologies(@PathVariable String name){
        return ResponseEntity.ok(technologyService.findAllTechnology(name));
    }
    /**
     * 添加关键技术
     * @return List
     */
    @PostMapping("/add")
    @ApiOperation("新添加关键技术")
    @AuthAnnotation(code = {"001100"})
    public ResponseEntity addTechnologies(@RequestBody Technology technology){
        technologyService.add(technology);
        return ResponseEntity.ok(200);

    }
    @PostMapping(value = "/{id}")
    @ApiOperation("修改关键技术")
    @AuthAnnotation(code = {"001100"})
    public ResponseEntity update(@RequestBody Technology technology,@PathVariable String id){
        technology.setId(id);
        technologyService.update(technology);
        return ResponseEntity.ok(200);
    }
    /**
     * 分页+多条件查询
     * @param searchMap 查询条件封装
     * @param page 页码
     * @param size 页大小
     * @return 分页结果
     */
    @ApiOperation("分页查询页面列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name="page",value = "页码",required=true,paramType="path",dataType="int"),
            @ApiImplicitParam(name="size",value = "每页记录数",required=true,paramType="path",dataType="int")
    })
    @RequestMapping(value="/search/{page}/{size}",method=RequestMethod.POST)
    @AuthAnnotation(code = {"001100"})
    public ResponseEntity findSearch(@RequestBody Map searchMap , @PathVariable int page, @PathVariable int size){
        Page<Technology> pageList = technologyService.findSearch(searchMap, page, size);
        return  ResponseEntity.ok(new PageResult<Technology>(pageList.getTotalElements(), pageList.getContent()) );
    }

}
