package com.zjty.inspect.service.impl;

import com.zjty.inspect.entity.DocumentContent;
import com.zjty.inspect.entity.DocumentPage;
import com.zjty.inspect.entity.TitleHead;
import com.zjty.inspect.service.DocumentService;
import com.zjty.inspect.utils.DocumentWordUtil;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;

@Service
public class DocumentServiceImpl implements DocumentService {
    @Override
    public String createDocument(DocumentPage documentPage) {
        StringBuilder sb=new StringBuilder();
        //前面部分内容
        String standard = DocumentWordUtil.standard();
        String enddard = DocumentWordUtil.enddard();
        //标题内容
        String maintitle = DocumentWordUtil.Maintitle();
        String subheading = DocumentWordUtil.subheading();
        //标题下的内容
        String standContent = DocumentWordUtil.content();
        //表格内容


        //页眉
        String header = documentPage.getHeader();
        String s1 = maintitle.replaceAll("#title#", header);
        sb.append(standard);
        sb.append(s1);
        List<TitleHead> titleHeads = documentPage.getTitleHeads();
        if(titleHeads!=null&&titleHeads.size()>0){
            for (TitleHead titleHead : titleHeads) {
                String titleContent=subheading;

                //标题名称
                String name = titleHead.getName();
                if(!StringUtils.isEmpty(name)) {
                    //标题级别
                    int parentId = titleHead.getParentId();
                    String s = titleContent.replaceAll("#title#", name)
                            .replaceAll("#parentId#", String.valueOf(parentId));
                    sb.append(s);
                }
                List<DocumentContent> documentContents = titleHead.getDocumentContents();
                if(documentContents!=null&&documentContents.size()>0){
                    for (DocumentContent documentContent : documentContents) {
                            if(documentContent!=null){
                                String content = documentContent.getContent();
                                String baseUrl = documentContent.getBaseUrl();
                                String documentTable = documentContent.getDocumentTable();
                                if(!StringUtils.isEmpty(content)){
                                    String c=standContent;
                                    String s = c.replaceAll("#content#",content);
                                    sb.append(s);
                                }
                                if(!StringUtils.isEmpty(baseUrl)){

                                }
                                if(!StringUtils.isEmpty(documentTable)){
                                    sb.append(documentTable);
                                }
                            }
                    }
                }
            }
        }
        sb.append(enddard);
        return sb.toString();
    }
}
