package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.entity.TechnologyQo;
import com.zjty.inspect.entity.Technology;
import com.zjty.inspect.service.TechnologyService;
import com.zjty.inspect.utils.UUIDUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 适配技术
 * @author Mcj
 * @date 2020-02-27 12:00
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class TechnologyServiceImpl implements TechnologyService {

    @Autowired
    private TechnologyDao technologyDao;

    /**
     * 新增适配技术
     * @param technologyQo 前端数据封装类
     */
    @Override
    public void addAdvice(TechnologyQo technologyQo) {
        if(technologyDao.findAllByTechnologyNameEquals(technologyQo.getTechnologyQoName())==null){
            Technology technology = new Technology();
            technology.setFund(technologyQo.getFund());
            technology.setAdvice(technologyQo.getAdvice());
            technology.setTechnologyName(technologyQo.getTechnologyQoName());
            technology.setId(UUIDUtil.getUUID());
            technologyDao.save(technology);
        }
    }

    @Override
    public List<Technology> findAllTechnology() {
        return technologyDao.findAll();
    }
}
