package com.zjty.inspect.aop;

import com.zjty.inspect.entity.User;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author Mcj
 * @date 2020-04-02 13:49
 */

@Aspect
@Slf4j
@Component
public class AopIntercept {

    private User user;

    public void setUser(User user) {
        this.user = user;
    }

    @Pointcut("@annotation(com.zjty.inspect.aop.AuthAnnotation)")
    public void doPointCut() {
    }

    @Around("doPointCut()")
    public Object aroundMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        long startMillis = System.currentTimeMillis();
        Object proceed = joinPoint.proceed();
        long endMillis = System.currentTimeMillis();

        long time = (endMillis - startMillis);
        log.info("评估总耗时{}毫秒",time);
        log.info("PersonAspect2 ==> before method : {}", joinPoint.getSignature().getName());
        log.info("注解的类型名称为{}",joinPoint.getSignature().getDeclaringTypeName());
        log.info("方法修饰符个数为{}",joinPoint.getSignature().getModifiers());
        log.info("方法名称为{}",joinPoint.getSignature().getName());
        log.info("方法参数{}",joinPoint.getArgs());
        return proceed;
    }
}
