package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
@ApiModel(value = "浏览器插件")
@Getter
public enum  BrowserPlugEnum {
    NONE(-1,"无"),
    DOWNLOAD(1,"下载/上传"),
    PRINT(2,"打印调用"),
    SCAN(3,"扫描调用"),
    YIWEIMA(4,"一维码/二维码调用"),
    OCR(5,"OCR调用"),
    MOBILE(6,"移动设备同步"),
    TEXT(7,"在线文本编辑类"),
    TABLE(8,"在线表单编辑类"),
    CHART(9,"在线统计图表展现类"),
    VIDEO(10,"在线视频播放类"),
    THREED(11,"在线3D建模、渲染、展现"),
    GIS(12,"在线GIS类"),
    PERIPHERAL(13,"调用其他外设"),
    ANIMATION(14,"动画"),
    FLASH(14,"Flash"),
    OTHER(13,"其他");

    private Integer code;
    private String name;

     BrowserPlugEnum() {
    }

     BrowserPlugEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
}
