package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.TechnologyDao;
import com.zjty.inspect.dao.RuleDao;
import com.zjty.inspect.entity.Technology;
import com.zjty.inspect.entity.Rule;
import com.zjty.inspect.entity.RuleQo;
import com.zjty.inspect.service.RuleService;
import com.zjty.inspect.utils.UUIDUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 规则库
 * @author Mcj
 * @date 2020-02-26 15:05
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class RuleServiceImpl implements RuleService {

    /**
     * 规则库dao
     */
    @Autowired
    private RuleDao ruleDao;

    /**
     * 新增规则
     * @param ruleQo 规则封装类
     */
    @Override
    public void addRule(RuleQo ruleQo) {
        // TODO: 2020-02-27 适配技术与扫描关键字关联
        Rule rule = new Rule();
        rule.setTarget(ruleQo.getTarget());
        rule.setSuffix(ruleQo.getSuffix());
        rule.setTechnologyId(ruleQo.getTechnologyId());
        rule.setId(UUIDUtil.getUUID());
        ruleDao.save(rule);
    }

    @Override
    public void upRule(RuleQo ruleQo) {
        Rule rule = new Rule();
        rule.setTarget(ruleQo.getTarget());
        rule.setSuffix(ruleQo.getSuffix());
        rule.setTechnologyId(ruleQo.getTechnologyId());
        rule.setId(ruleQo.getId());
        ruleDao.save(rule);
    }

    @Override
    public void deleteById(String id) {
        ruleDao.deleteById(id);
    }

    @Override
    @Modifying
    public void deleteRule(RuleQo ruleQo) {
        ruleDao.deleteById(ruleQo.getId());
    }

    /**
     * 查询所有规则
     * @return RuleVoList
     */
    @Override
    public List<Rule> findAll() {
        return ruleDao.findAll();
    }

    @Override
    public List<Rule> findByName(String name) {
        List<Rule> rules = ruleDao.findAllByTargetLike("%" + name + "%");
        if(rules!=null&&rules.size()>0){
            return rules;
        }
        return null;
    }
}
