package com.zjty.inspect.controller;

import com.zjty.inspect.config.WebSocketServer;
import com.zjty.inspect.entity.ServerResponse;
import com.zjty.inspect.thread.task.AsyncTask;
import com.zjty.inspect.utils.ExceptionMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: liujie-cloud
 * @description: WebSocketController，用于消息推送
 * @author: LiuJie
 * @create: 2019-05-17 10:12
 **/

@Api(description = "WebSocketController接口")
@RequestMapping("/webSocket")
@RestController
public class WebSocketController {
    /**
     * 日志对象
     */
    private static final Logger logger = LoggerFactory.getLogger(WebSocketController.class);

    @Autowired
    private AsyncTask asyncTask;


    /**
     * @Description:  推送数据到所有的WebSocket客户端
     * @Param:
     * @return:
     * @Author: LiuJie
     * @Date: 2019/6/3
     */
    @ApiOperation(value = "推送数据到所有的WebSocket客户端" ,  notes="推送数据到所有的WebSocket客户端")
    @RequestMapping(value="/push/{msg}",method= RequestMethod.GET)
    public ServerResponse pushToAll(@PathVariable("msg")String msg){
        try {
            Map<String, String> map = new HashMap<>();
            map.put("msg",msg);
            asyncTask.sendMessageToAll(map);
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("推送消息到客户端报错:"+info);
            return ServerResponse.error("推送消息到客户端报错:"+info);
        }
        return ServerResponse.ok(200);
    }
}