package com.zjty.inspect.utils;

import com.zjty.inspect.dao.CoefficientModelDao;
import com.zjty.inspect.entity.Budget;
import com.zjty.inspect.entity.CoefficientModel;
import com.zjty.inspect.entity.InspectParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 获取预算
 * @author Mcj
 * @date 2020-02-26 15:14
 */

@Component
public class BudgetUitl {


    @Autowired
    private CoefficientModelDao coefficientModelDao;

    /**
     * 获取预算数据
     * @param fund 技术费用
     * @param inspectParameter  计算所需数据
     * @return
     */
    public List<Budget> getBudget(Integer fund, InspectParameter inspectParameter){
        inspectParameter.setMoneyRate(1.04);
        inspectParameter.setProportion(0.6);
        int scale;
        Integer systemFund = inspectParameter.getSystemFund();
        if(systemFund==0){
            double v = inspectParameter.getModules() * 7.5;
            systemFund= (int) v;
        }
        if(systemFund<30){
            scale=1;
        }else if(systemFund<200){
            scale=2;
        }else{
            scale=3;
        }
        Budget budget = new Budget();
        budget.setBudgetName("代码重构预算");
        Double moneyRate = inspectParameter.getMoneyRate();
        int i = 2020 - inspectParameter.getYears();
        double pow = Math.pow(moneyRate, i);
        //不带修正系数资金
        double v = inspectParameter.getProportion() * pow * systemFund + fund;
        //带修正系数资金
        ArrayList<String> strings = new ArrayList<>();
        Double v1 = v;
        strings.add("安全能力");
        strings.add("容灾能力");
        strings.add("架构");
        strings.add("数据量");
        strings.add("模块数");
        List<CoefficientModel> nameIn = coefficientModelDao.findAllByNameIn(strings);
        List<CoefficientModel> collect = nameIn.stream().filter(a -> a.getScale() == scale).collect(Collectors.toList());
        for (CoefficientModel model : collect) {
            if("架构".equals(model.getName())){
                Double aDouble = model.countCoefficient(inspectParameter.getFramework());
                v1*=aDouble;
            }else if("容灾能力".equals(model.getName())){
                Double aDouble = model.countCoefficient(inspectParameter.getDisaster());
                v1*=aDouble;
            }
            else if("安全能力".equals(model.getName())){
                Double aDouble = model.countCoefficient(inspectParameter.getSafety());
                v1*=aDouble;
            }
            else if("数据量".equals(model.getName())){
                Double aDouble = model.countCoefficient(Double.valueOf(inspectParameter.getData()));
                v1*=aDouble;
            }
            else if("模块数".equals(model.getName())){
                Double aDouble = model.countCoefficient(Double.valueOf(inspectParameter.getModules()));
                v1*=aDouble;
            }
        }

        if(v<v1){
            budget.setFund(v +"--"+v1);
        }else if(v>v1){
            budget.setFund(v1 +"--"+v);
        }else{
            budget.setFund(v1 +"--"+v);
        }
        budget.setFundDetail("普通业务开发费用:"+v);
        budget.setFundDetail("普通业务开发费用(修正):"+v1);
        budget.setFundDetail("关键适配技术成本:"+fund);

        ArrayList<Budget> budgets = new ArrayList<>();
        budgets.add(budget);
        return budgets;
    }
}
