package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.sql.Timestamp;

/**
 * 预算
 * @author Mcj
 * @date 2020-02-27 19:05
 */
@ApiModel(value = "预算")
@Data
public class Budget {

    /**
     * 名称
     * 代码重构预算
     * 代码修改预算、
     */
    private String budgetName;
    /**
     * 资金
     */
    private String fund;

    /**
     * 资金详情
     */
    private String fundDetail;

    /**
     * 占比
     */
    private double proportion;

    /**
     * 系统开发费用
     */
    @ApiModelProperty(value = "系统开发费用",example = "1")
    private Integer sysFund;

    /**
     * 年利率
     */
    private double moneyRate;

    /**
     * 修正系数
     */
    private double coefficient;

}
