package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 基础工作量评估</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 18:44
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "基础工作量评估")
public class Workload {
    /**
     * 描述
     */
    private String des;

    /**
     * 开发费用
     */
    private double cost;

    /**
     *模块数
     */
    @ApiModelProperty(value = "模块数",example = "1")
    private Integer mode;

    /*
     * 依据
     */

    /**
     * 开发
     */
    private Basis development = new Basis();

    /**
     * 测试
     */
    private Basis test = new Basis();

    /**
     * 部署
     */
    private Basis deploy = new Basis();

    /**
     * 合计
     */
    private Basis total = new Basis();
}
