[TOC]

#介绍

项目评估服务是一个springboot架构的微服务。主要功能是对需要替换开发的系统的源代码进行评估产生评估报告.根据用户配置的规则,关键字,帮助用户进行国产化适配。

评估报告提供以下信息

- 开发语言
- 源代码地址
- 项目管理方式
- 项目依赖
- 国产化适配建议

#核心功能

- 提供评估

  - 基本信息评估

    - 源代码信息展示以下数据

      `开发语言,源代码位置,项目管理方式`

    - 针对特定语言依赖展示以下数据

      `java的jar包依赖`

  - 国产化适配评估

    - 给出用户国产化适配建议

      `源代码位置,关键字,建议`

      `国产化环境不能支持的依赖,关键字,建议`

- 提供增删改查规则库

- Git,https下载源代码并评估

- 上传源代码到微服务并评估

- 下载评估报告html

- 评估历史查看(文件地址,评估记录,评估时间)

- 在线查看评估报告

- 预算统计

# 管理功能

- 配置参数管理
- 报告管理
- 页面参数管理
- 规则管理
- 技术管理

## 核心功能详细设计

### 提供评估

- 基本信息评估

  - 源代码信息展示以下数据

    `开发语言,源代码位置,项目管理方式等`

  - 针对特定语言依赖展示以下数据

    `java的jar包依赖`

- 国产化适配评估

  - 给出用户国产化适配建议

    `源代码位置,关键字,建议`

- 流程

![评估流程1](/Users/mcj/Downloads/图片/2.jpg)

### 提供增删改查规则库

![评估流程1](/Users/mcj/Downloads/图片/未命名文件.jpg)

- 新增适配技术库与适配技术,修改目标关键字

- 新增规则库

- 查询所有适配技术及其关联规则


### 预算统计参数配置

- 适配重构参数配置
  - 重构占比:
  - 年复利率
  - 原系统开发费用
  - (每个技术点价格,就是建议)可以扫描
  - (需要计算)修正系数

### 默认修正系数表

| 规模     | 内容     | 适用范围 | 功能     | 代码量  | 页面数 | 数据库表数 | 数据量 | 架构   | 安全能力          | 容灾能力    | 前端适配系数 |
| -------- | -------- | -------- | -------- | ------- | ------ | ---------- | ------ | ------ | ----------------- | ----------- | ------------ |
| 小型     | 简单     | 单位内部 | 1-4模块  | <10k    | <10    | <10        | <1g    | 单机   | 无0,弱0.1,强0.2   | 无0,有+0.05 |              |
| 中型     | 某类业务 | 垂直     | 4-10模块 | 10-100k | 10-100 | 10-100     | 1-100g | bs/cs  | 弱0,无-0.1,强0.1  | 有0,无-0.05 |              |
| 大型     | 综合     | 多部门   | 10以上   | >100k   | >100   | >100       | >100g  | 分布式 | 强0,无-0.2,弱-0.1 | 有0,无-0.1  |              |
| 修正影响 | 0.2      | 0.2      | 0.3      | 0.1     | 0.05   | 0.2        | 0.05   | 0.1    | 0.1               | 0.05        | 0.05         |

## 数据库设计

### rule(规则表)

| 字段名称      | 字段类型  | 长度 | 默认值 | 是否主键 | 注释         |
| ------------- | --------- | ---- | ------ | -------- | ------------ |
| id            | int       | 100  |        | 是       | 主键id       |
| target        | varchar   | 100  |        |          | 目标字符串   |
| create_time   | timestamp |      |        |          | 数据创建时间 |
| update_time   | Timestamp |      |        |          | 数据更新时间 |
| file_suffix   | varchar   | 50   |        |          | 搜索文件后缀 |
| technology_id | varchar   | 100  |        |          | 匹配技术id   |

### 匹配技术表

| 字段名称        | 字段类型  | 长度 | 默认值 | 是否主键 | 注释             |
| --------------- | --------- | ---- | ------ | -------- | ---------------- |
| id              | varchar   | 100  |        | 是       | 主键id           |
| technology_name | varchar   | 100  |        |          | 技术名称         |
| advice          | varchar   | 100  |        |          | 技术建议         |
| create_time     | timestamp |      |        |          | 数据创建时间     |
| update_time     | timestamp |      |        |          | 数据更新时间     |
| fund            | int       | 10   |        |          | 单技术预算       |
| support         | int       | 10   |        |          | 1:支持、2:不支持 |
| backOrFront     | int       | 10   |        |          | 1:后端、2:前端   |

### 系数表

| 字段名称          | 字段类型 | 长度 | 默认值 | 是否主键 | 注释     |
| ----------------- | -------- | ---- | ------ | -------- | -------- |
| id                | varchar  | 100  |        | 是       | 主键     |
| name              | varchar  | 100  |        |          | 系数名称 |
| topCoefficient    | Double   | 10   |        |          | 高       |
| mediumCoefficient | Double   | 10   |        |          | 中       |
| belowCoefficient  | Double   | 10   |        |          | 低       |
| min               | 最小值   | 10   |        |          | 最小值   |
| max               | int      | 10   |        |          | 最大值   |
| scale             | Int      | 10   |        |          | 规模     |

