[TOC]

# 快速评估服务接口文档保姆级

## 数据实体

- 预算-Budget
- 预算显示-BudgetVO
- 系数模型-CoefficientModel
- 依赖-DependencyVo
- 参数封装-InspectParameter
- 报告-Report
- 报告显示-ReportVO
- 规则关键字-Rule
- 规则封装-RuleQo
- 规则显示-RuleVo
- 关键技术-Technology
- 匹配点-Warn

## 核心方法

- ```java
  InspectService.inspect(ReportVo reportVo,InspectParameter inspectParameter)
  ```

  - 作用：提供代码评估并进行数据返回
  - 参数：
    - reportVo：报告对象实体
    - inspectParameter：入口参数封装实体
  - 返回:填充完毕的reportVo

- ```java
  Inspect.Inspector
  ```

  - ```java
    public ReportVo inspect()
    ```

    功能:

    接口主要功能是对用户上传的源代码进行分析

    分析的依据是

    - rule：配置关键字与文件后缀，如：native，java
    - Technology:关键技术，关键技术与rule的关系是一对多

    ### 步骤

    - 将规则根据配置的匹配后缀进分类
    - 对源代码进行扫描，按照源代码中的文件后缀分类
    - 把指定后缀的文件与指定后缀的规则进行匹配，并全文扫描进行关键字的搜索(文字匹配利用kmp算法)
    - 统计数据,封装返回

  - ```java
    private void initData()
    ```

    功能:初始化数据

  - ```java
    public void scanFiles();
    ```

    功能:扫描所有源文件并且分类

  - ```java
    private void setReportLanguageAndFrame() 
    ```

    功能:比对源文件数量得出语言架构

  - ```java
    private void ruleTransform(Integer status)
    ```

    功能:根据用户评估的方式查询用户所需要的所有规则

  - ```java
    private void forEachFilesMap() 
    ```

    功能:根据规则后缀分类以及文件后缀分类进行匹配,并验证是否匹配某规则.并记录

  - ```java
    private void setRule(StringBuilder stringBuilder, PomDependency dependency) 
    ```

    功能:得到pom.xml内的依赖,并且判断是否匹配了某项规则,是否添加进数据库

  - ```java
    public int valiWarn(List<Rule> rules, Path path, String data, int num) 
    ```

    功能:判断是否有规则与传入的data匹配,如果有就记录

- ```java
  Controller.InspectController
  ```

  - ```java
    public ServerResponse rapidAssessment(@RequestBody Reform reform) throws IOException 
    ```

    功能:根据前端页面封装的reform,获取评估所需要的信息后,先进行快速评估(在com.zjty.inspect.inspect.inspector)

    快速评估完成后进行详细评估(在com.zjty.inspect.controller.inspectController)输出一份详细表格,将表格数据根据入参与出参保存进数据库

- ```java
  utils.BudgetUitl
  ```

  功能:根据用户页面配置计算预算(适配预算、修改预算、改造预算),预算算法在软件ak预算算法文件中

# 预算评估

快速评估中关于如何计算预算的方法在当前文件夹下软件系统ak预算方法pdf中有写

## 计算预算必要参数

- 年复利率(moneyRate)=1.04
- 占比(proportion)
  - 重构比=0.6
  - 修改替换比=0.3
  - 适配前端页面=0.15
- 原系统开发费用(systemFund)=数字

## 可选变量

- 软件运行时间(years)=数字
- 模块数(modules)=数字
- 代码量(codeSize)=数字
- 数据库表(table)=数字
- 数据量(data)=数字
- 架构(framework)=单机(0)、bs、cs(2)、分布式(4)
- 安全能力(safety)无(0)、弱(2)、强(4)
- 容灾能力(disaster)无(0)、有(4)
- 内容(content)：小型(0),中型(2),大型(4)，取最大值

根据系数表设计

为什么是0、4呢，因为设置是小于1或者大于3

# 系统必要参数

- admin：是否管理员
  - 1:管理员
  - 2:用户
- projectName：项目名称
- databaseType：数据库类型
- method：评估方式
  - 1:系统修改
  - 2:系统适配
- username：用户名
- valid：是否需要进行预算计算
  - 1:是
  - 2:否
- multiple:zip或者rar文件

## 页面显示(改造评估)

改造评估页面

- 原系统开发费用
- 容灾能力
- 模块数
- 代码量
- 数据库表

系统级配置

- 占比
  - 重构比
  - 修改替换比
  - 适配前端页面
- 年复利率

第一个页面

适配占比此时0.15，要去计算是否需要重构，如果需要重构 ，则计算重构的钱，否则计算适配的钱

第二个页面

改造占比0.3，评估是否需要重构，如果需要重构，计算重构的钱，否则计算改造的钱

# 常见错误排除

- 评估建议无法显示
  - 首先查看ruleSuffixFilePathMap中是否已经将文件扫描并且分类
  - 再查看ruleSuffixMap中是否查询出了规则并且分类
- 评估建议缺少
  - 查看ruleTransform方法是否根据用户配置的评估方法查询出了规则
- 快速评估显示金额错误
  - 调试budgetUtil文件传入参数是否正确,用户配置年利率、改造适配占比是否正确,可选参数系数表是否正确

# 优化

- 报告的入参以及输进行拆分称表字段,因为数据太大导致数据传输很慢,单表会非常庞大

- 规则匹配方式的优化,寻找更加优秀的文档字符匹配方式