package com.zjty.inspect.config;

import com.zjty.inspect.entity.ServerResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @author Mcj
 * @date 2020-03-16 10:33
 */
@RestControllerAdvice
@Slf4j
public class ExceptionHandlerConfig {

    @ExceptionHandler(value = HttpMessageNotReadableException.class)
    public ServerResponse defaultErrorHandler(Exception e) {
        log.error("http请求错误{}",e);
        return ServerResponse.badRequest();
    }
    @ExceptionHandler(value = IOException.class)
    public ServerResponse defaultIOHandler(Exception e) {
        log.error("IO异常{}",e);
        return ServerResponse.error();
    }
    @ExceptionHandler(value = Exception.class)
    public ServerResponse defaultLargestExceptionHandler(Exception e) {
        log.error("最大异常{}",e);
        return ServerResponse.error();
    }
}
