package com.zjty.inspect.dao;

import com.zjty.inspect.entity.MasterEvaluation;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

public interface MasterEvaluationDao extends JpaRepository<MasterEvaluation,String>, JpaSpecificationExecutor<MasterEvaluation> {
    MasterEvaluation findByUsernameAndIdNot(String username, String id);
    MasterEvaluation findByUsername(String username);
    @Query(value = "SELECT * FROM master_evaluation WHERE username=:username AND create_time = (SELECT MAX(create_time) FROM evaluation WHERE username=:username)",nativeQuery = true)
    MasterEvaluation findByUsernameAndMaxCreateDate(String username);



}
