package com.zjty.inspect.dao;

import com.zjty.inspect.entity.MasterRuleCollection;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * @author mcj
 */
public interface MasterRuleCollectionDao extends JpaRepository<MasterRuleCollection, String>, JpaSpecificationExecutor<MasterRuleCollection> {
    /**
     * 根据技术id以及关键字查询数据
     * @param technologyId 技术id
     * @param target 关键字
     * @return
     */
    MasterRuleCollection findAllByTechnologyIdEqualsAndTargetEquals(String technologyId, String target);

    /**
     * 根据关键字查询数据
     * @param target 关键字
     * @return
     */
    List<MasterRuleCollection> findAllByTargetLike(String target);
}
