package com.zjty.inspect.dao;


import com.zjty.inspect.entity.MasterRule;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

public interface MasterRuleDao extends JpaRepository<MasterRule,String>,JpaSpecificationExecutor<MasterRule> {
    /**
     * 根据目标关键字查询规则
     * @param target 目标关键字
     * @return
     */
    MasterRule findAllByTargetEquals(String target);

    /**
     * 根据目标关键字查询规则
     * @param target 目标关键字
     * @param techId 关键技术id
     * @return
     */
    MasterRule findAllByTargetEqualsAndTechnologyIdEquals(String target, String techId);

    List<MasterRule> findAllByTargetLike(String target);
    List<MasterRule> findAllByTarget(String target);

    MasterRule findByTarget(String target);
    List<MasterRule> findByTargetIgnoreCase(String target);
    MasterRule findByTargetAndIdNot(String target, String id);

    List<MasterRule> findByTargetAndSuffixEqualsAndTechnologyIdEquals(String target, String suffix, String technologyId);

    /**
     * 根据技术id查询规则
     * @param ids 技术id
     * @return
     */
    List<MasterRule> findAllByTechnologyIdIn(List<String> ids);
    List<MasterRule> findAllByTechnologyId(String id);

    List<MasterRule> findAllByTechnologyIdEqualsAndTargetEquals(String techId, String target);
}
