package com.zjty.inspect.dao;

import com.zjty.inspect.entity.MasterTechnology;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

public interface TechnologyDao extends JpaRepository<MasterTechnology,String>, JpaSpecificationExecutor<MasterTechnology> {

    /**
     * 根据名称查询适配技术
     * @param name 适配技术名称
     * @return MasterTechnology
     */
    MasterTechnology findAllByTechnologyNameEquals(String name);
    Optional<MasterTechnology> findById(String id);
    /**
     * 模糊查询技术名称
     * @param name
     * @return
     */
    List<MasterTechnology> findAllByTechnologyNameLike(String name);

    /**
     * 根据id查询
     * @param ids ids
     * @return
     */
    List<MasterTechnology> findAllByIdIn(List<String> ids);


    @Query("select technologyName from MasterTechnology ")
    List<String> getTechnologyNames();

    /**
     * 查询不支持的技术个数
     * @param support 是否支持
     * @return
     */
    int countAllBySupportIsNot(Integer support);

    /**
     * 查询前端或者后端依赖技术
     * @param backOrFront
     * @return
     */
    List<MasterTechnology> findAllByBackorfrontEquals(Integer backOrFront);
}
