package com.zjty.inspect.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author sjq
 * @Date 20-8-6 下午4:35
 */
@Entity
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "评估报告预算类")
public class BudegReport {
    @Id
    @Column( length = 48)
    private String evaId;
    @Column(columnDefinition = "TEXT")
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private String budReport;
}
