package com.zjty.inspect.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Entity
//@Table(name = "master_eva_report")
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "评估报告管理类")
public class MasterEvaReport {
    @Id
    @Column( length = 48)
    private String id;
    private String username;
    /**
     * 0：用户
     * 1: 管理员
     */
    private Integer authority;
    /**
     * 1是删除
     * 0正常
     */
    private Integer del;
    private String projectName;
    /**
     * 数据创建时间
     */
    @Column(name="create_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false,updatable = false)
    @CreatedDate
    private Date createDate;

    /**
     * 数据更新时间
     */
    @Column(name="update_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP",insertable = false)
    @LastModifiedDate
    private Date updateDate;

    private String eva_id;
}
