package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * 报告
 * @author mcj
 */
//@Table(name = "master_report")
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "报告")
public class MasterReport {

    @Id
    private String id;
    /**
     * 生成报告存储地址
     */
    private String htmlAddress;

    private String username;
    /**
     * 数据创建时间
     */
    @Column(name="create_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false,updatable = false)
    @Generated(GenerationTime.INSERT)
    private Timestamp createDate;

    /**
     * 数据更新时间
     */
    @Column(name="update_time",columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP",insertable = false)
    @Generated(GenerationTime.ALWAYS)
    private Timestamp updateDate;
}
