package com.zjty.inspect.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * @author Mcj
 */
@Data
@ApiModel(value = "ReportVo")
public class ReportVo {

    private String id;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 上传类型
     */
    private String uploadType;
    /**
     * git源代码地址
     */
    private String gitAddress;

    /**
     * 架构，整合型还是分离型，根据jsp数量决定
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer framework;

    /**
     * 代码管理方式，
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer manager;

    /**
     * 数据库类型
     */
    private String databaseType;

    /**
     * 语言
     */
    @ApiModelProperty(value = "语言",example = "1")
    private Integer language;

    /**
     * 语言
     */
    @ApiModelProperty(value = "语言",example = "1")
    private List<Integer> languages;

    /**
     * 生成报告存储地址
     */
    private String htmlAddress;

    /**
     * 适配方式
     * 1：重构
     * 2：修改
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer recastMethod;

    /**
     * 源代码地址
     */
    private String sourceAddress;

    /**
     * 预算详情
     */
    private BudgetVo budgets;

    /**
     * 依赖
     */
    private DependencyVo dependencyVo;

    /**
     * 匹配技术列表
     */
    private List<MasterTechnology> technologies;

    /**
     * 告警点
     */
    private HashMap<String, List<Warn>> warnDetails;

    /**
     * 关键技术个数
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer technologiesNum;

    /**
     * 需要改造的技术
     */
    @ApiModelProperty(value = "权限",example = "1")
    private Integer technologiesRepair;

    /**
     * 文件个数
     */
    @ApiModelProperty(value = "权限",example = "1")
    private long fileNum;

    /**
     * 文件行数
     */
    @ApiModelProperty(value = "权限",example = "1")
    private long fileLine;
    @ApiModelProperty(value = "权限",example = "1")
    private long supportSize = 0;

    /**
     * 评估时间
     */
    @JsonFormat(pattern = "YYYY-MM-dd",timezone="GMT+8")
    private Date createDate = new Date();
}
