package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Timestamp;
import java.util.List;
@Data
public class TechnologySyn {
    private String id;

    /**
     * 技术名称
     */
    private String technologyName;

    /**
     * 技术建议
     */
    private String advice;

    /**
     * 金额(万元)
     */
    @ApiModelProperty(value = "金额",example = "123")
    private Integer fund;

    /**
     * 1：支持
     * 2：不支持
     * 3：未知
     * 4:不完全支持
     * 5：优化
     */
    @ApiModelProperty(value = "是否支持",example = "1")
    private Integer support;

    /**
     * 分类id
     */
    private String category_id;
    /**
     * 技术类型
     * 1:前端技术
     * 2：后端技术
     */
    @ApiModelProperty(value = "技术类型",example = "2")
    private Integer backOrFront =2;
    /**
     * 数据创建时间
     */
    private Timestamp createDate;

    /**
     * 数据更新时间
     */
    private Timestamp updateDate;

    private List<MasterRule> rules;
}
