package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

/**
 * 用户
 * @author mcj
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class User {
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("姓名")
    private String name;
    @ApiModelProperty("性别")
    private Integer sex;
    @ApiModelProperty("用户名")
    private String userName;
    @ApiModelProperty("密码")
    private String password;
    @ApiModelProperty("角色id")
    private Integer roleId;
    @ApiModelProperty("角色名称")
    private String roleName;
    @ApiModelProperty("联系方式")
    private String number;
    @ApiModelProperty("用户类型 1：后台，2：前台")
    private Integer type;
    @ApiModelProperty("本次登录的sessionId")
    private String sessionId;
    @ApiModelProperty("用户权限集合")
    private List<String> authorityCode;
}
