package com.zjty.inspect.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum DocumentTitleEnum {
    MAINTITLE(0,"主标题",2,0,0),
    FIRSTLEVELTITLE(1,"一级标题",2,0,1),
    TWOTITLE(2,"二级标题",3,1,2),
    THREETITLE(3,"三级标题",4,2,2),
    FOURTITLE(4,"四级标题",5,3,2),
    OTHER(8,"其他",0,0,0);

    private Integer code;
    private String name;
    private Integer style;
    private Integer ilvl;
    private Integer ilfo;
    private static Map<Integer,DocumentTitleEnum> documentTitleEnumMap=new HashMap<>();

    static {
        for (DocumentTitleEnum documentTitleEnum : DocumentTitleEnum.values()) {
            documentTitleEnumMap.put(documentTitleEnum.getCode(),documentTitleEnum);
        }
    }
     DocumentTitleEnum() {
    }

     DocumentTitleEnum(Integer code, String name, Integer style, Integer ilvl, Integer ilfo) {
        this.code = code;
        this.name = name;
        this.style = style;
        this.ilvl = ilvl;
        this.ilfo = ilfo;
    }

    public static DocumentTitleEnum getByCode(Integer code){
        DocumentTitleEnum documentTitleEnum = documentTitleEnumMap.get(code);
        if(documentTitleEnum==null){
            return null;
        }
        return documentTitleEnum;
    }
}
