package com.zjty.inspect.enums;

import java.util.HashMap;
import java.util.Map;

public enum Framework {

    /**
     * 架构
     */
    SEPARATE("分离型架构",1),
    MIXTURE("混合型架构",2),
    NONE("无",3);
    Framework(String name,Integer status){
        this.name=name;
        this.status=status;
    }

    private String name;

    private Integer status;

    public String getName() {
        return name;
    }

    public Integer getStatus() {
        return status;
    }
    private static Map<String,Framework> frameWorkEnumMap=new HashMap<>();
    private static Map<Integer,Framework> frameWorkEnumCodeMap=new HashMap<>();

    static {
        for (Framework frameWorkEnum : Framework.values()) {
            frameWorkEnumMap.put(frameWorkEnum.getName(),frameWorkEnum);
            frameWorkEnumCodeMap.put(frameWorkEnum.getStatus(),frameWorkEnum);
        }
    }
    public static Framework getByName(String name){
        Framework frameWorkEnum = frameWorkEnumMap.get(name);
        if(frameWorkEnum==null){
            return NONE;
        }
        return frameWorkEnum;
    }
    public static Framework getByCode(Integer code){
        Framework frameWorkEnum = frameWorkEnumCodeMap.get(code);
        if(frameWorkEnum==null){
            return NONE;
        }
        return frameWorkEnum;
    }
}
