package com.zjty.inspect.enums;

import io.swagger.annotations.ApiModel;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "微服务")
@Getter
public enum MicroServiceEnum {
    NONE(-1,"无",0),
    FLUME(0,"Flume",0),
    ZOOKEEPER(1,"Zookeeper",0),
    RIBBON(2,"Ribbon",0),
    HYSTIX(3,"Hystix",0),
    HBASE(4,"HBASE",0),
    HIVE(5,"Hive",0),
    SPARKSTROM(6,"Spark Strom",0),
    RESTTEMPLATE(7,"RestTemplate",0),
    KVM(8,"KVM",0),
    OPENSTACK(9,"Openstack",0),
    KUBERNETES(10,"Kubernetes",0),
    DOCKER(11,"Docker",0),
    EXMOBI(12,"Exmobi",0),
    DATAV(13,"DataV",0),
    RAYDATA(14,"RayData",0),
    BIANMU(15,"编目服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    DITU(16,"地图类微服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    TUBIAO(17,"图表视图类微服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    SHIBIE(18,"识别类微服务：请在备注中填写",1),
    NEIRONG(19,"内容审查类微服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    FENXI(20,"智能分析类微服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    DATA(21,"数据引用类微服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    IOQUICK(22,"流媒体加速类微服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    JIAMI(23,"加密类微服务：请在备注中填写,如需填写多个,请以逗号分隔",1),
    OTHER(24,"其他：请在备注中填写,如需填写多个,请以逗号分隔",1);
    private Integer code;
    private String name;
    private Integer other;

    MicroServiceEnum() {
    }
    private static Map<String,MicroServiceEnum> microServiceEnumMap=new HashMap<>();
    static {
        for (MicroServiceEnum microServiceEnum : MicroServiceEnum.values()) {
            microServiceEnumMap.put(microServiceEnum.getName(),microServiceEnum);
        }
    }
    MicroServiceEnum(Integer code, String name,Integer other) {
        this.code = code;
        this.name = name;
        this.other=other;
    }
    public static MicroServiceEnum getByName(String name){
        MicroServiceEnum microServiceEnum = microServiceEnumMap.get(name);
        if(microServiceEnum == null){
            return NONE;
        }
        return microServiceEnum;
    }
}
