package com.zjty.inspect.enums;

import java.util.HashMap;
import java.util.Map;

public enum RecastMethod {

    RECONSITUTION("代码重构",1),
    MODIFICATION("代码修改",2),
    NOMODIFICATION("无需代码修改",3);

    RecastMethod(String name, Integer status){
        this.name=name;
        this.status=status;
    }

    private String name;

    private Integer status;

    public String getName() {
        return name;
    }

    public Integer getStatus() {
        return status;
    }
    private static Map<String,RecastMethod> recastMethodEnumMap=new HashMap<>();
    private static Map<Integer,RecastMethod> recastMethodCodeEnumMap=new HashMap<>();

    static {
        for (RecastMethod recastMethod : RecastMethod.values()) {
            recastMethodEnumMap.put(recastMethod.getName(),recastMethod);
        }
        for (RecastMethod recastMethod : RecastMethod.values()) {
            recastMethodCodeEnumMap.put(recastMethod.getStatus(),recastMethod);
        }
    }
    public static RecastMethod getByName(String name){
        RecastMethod recastMethod = recastMethodEnumMap.get(name);
        if(recastMethod==null){
            return NOMODIFICATION;
        }
        return recastMethod;
    }
    public static RecastMethod getByCode(Integer code){
        RecastMethod recastMethod = recastMethodCodeEnumMap.get(code);
        if(recastMethod==null){
            return NOMODIFICATION;
        }
        return recastMethod;
    }
}
