package com.zjty.inspect.service;

import com.zjty.inspect.entity.*;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * 规则接口
 */
public interface RuleService {

    /**
     * 新增规则
     * @param ruleQo 规则封装类
     */
    public void addRule(RuleQo ruleQo);
    public MasterRule addRulePlus(MasterRule rule);
    public void addListRulePlus(List<MasterRule> rules);

    public void addRule(List<MasterRule> rules);
    /**
     * 修改规则
     * @param ruleQo 规则封装类
     */
    public void upRule(RuleQo ruleQo);
    public void upRulePlus(MasterRule rule);
    public String exportData();
    /**
     * 删除规则
     * @param ruleQo 规则封装类
     */
    public void deleteRule(RuleQo ruleQo);
    public void deleteRulePlus(String id);

    /**
     * 查询所有规则
     * @return 规则
     */
    List<MasterRuleCollection> findAll();

    /**
     * 查询所有规则
     * @return 规则
     */
    List<MasterRule> findRules();

    List<MasterRuleCollection> findByName(String name);
    Page<MasterRule> findSearch(Map searchMap, int page, int size);

    List<MasterRule> findAllByTechnologyIdIn(List<String> technologyIds);

    void importRules(MultipartFile file);

}
