package com.zjty.inspect.service;

import com.zjty.inspect.entity.MasterTechnology;
import com.zjty.inspect.entity.TechnologyQo;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * 关键技术
 * @author mcj
 */
public interface TechnologyService {
    /**
     * 新增关键技术点
     */
    public void addAdvice(TechnologyQo technologyQo);
    public void add(MasterTechnology technology);
    public void addTech(MasterTechnology technology);

    /**
     * 查询所有技术
     * @return List
     */
    public List<MasterTechnology> findAllTechnology();
    public List<String> findAllTechnologyNames();

    public  List<MasterTechnology> findAllTechnology(String name);

    void update(MasterTechnology technology);

    Page<MasterTechnology> findSearch(Map searchMap, int page, int size);

    /**
     * 查询全部技术个数
     * @return 查询技术数量
     */
    int findAllTechnologyCount();

    /**
     * 查询不支持的技术个数
     * @return 查询技术数量
     */
    int findAllTechnologyNotSupport();

    MasterTechnology findByid(String technologyId);
}
