package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.MasterConfigParamDao;
import com.zjty.inspect.entity.MasterConfig;
import com.zjty.inspect.service.ConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
@Transactional(rollbackFor = Exception.class)
public class ConfigServiceImpl implements ConfigService {

    @Autowired
    private MasterConfigParamDao masterConfigParamDao;
    @Override
    public void updateConfig(List<MasterConfig> configs) {
        List<MasterConfig> configList=new ArrayList<>();
        for (MasterConfig config : configs) {
            Optional<MasterConfig> optional = masterConfigParamDao.findById(config.getId());
            if (optional.isPresent()) {
                MasterConfig c = optional.get();
                c.setValue(config.getValue());
                configList.add(c);
            }
        }
        masterConfigParamDao.saveAll(configList);

    }

    @Override
    public List<MasterConfig> findAll() {
        return masterConfigParamDao.findAll();
    }
}
