package com.zjty.inspect.service.impl;

import com.zjty.inspect.dao.MasterEvaReportDao;
import com.zjty.inspect.dao.MasterEvaluationDao;
import com.zjty.inspect.entity.MasterEvaReport;
import com.zjty.inspect.entity.MasterEvaluation;
import com.zjty.inspect.service.EvaluationService;
import com.zjty.inspect.utils.UUIDUtil;
import io.netty.util.internal.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
public class EvaluationServiceImpl implements EvaluationService {
    @Autowired
    private MasterEvaReportDao evaReportDao;
    @Autowired
    private MasterEvaluationDao evaluationDao;

    @Override
    public MasterEvaluation save(MasterEvaluation evaluation) {
        log.info("evaluation为:{}",evaluation);
        if (StringUtils.isEmpty(evaluation.getInEva())) {
            return null;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getOutEva())) {
            return null;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getUsername())) {
            return null;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getProjectName())) {
            return null;
        }
        String uuid = UUIDUtil.getUUID();
        evaluation.setId(uuid);
        return evaluationDao.save(evaluation);
    }

    @Override
    public void update(MasterEvaluation evaluation) {
        MasterEvaluation evaluation1 = evaluationDao.findByUsernameAndIdNot(evaluation.getUsername(), evaluation.getId());
        if (evaluation1 != null) {
            return;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getInEva())) {
            return;
        }
        if (StringUtil.isNullOrEmpty(evaluation.getOutEva())) {
            return;
        }
        evaluationDao.save(evaluation);

    }
    public void test(){
        List<MasterEvaluation> all = evaluationDao.findAll();
        for (MasterEvaluation evaluation : all) {
            Optional<MasterEvaReport> optional = evaReportDao.findById(evaluation.getId());
            if(!optional.isPresent()){
                evaluation.setDel(0);
                MasterEvaReport evaReport = new MasterEvaReport();
                BeanUtils.copyProperties(evaluation,evaReport);
                evaluationDao.save(evaluation);
                evaReportDao.save(evaReport);
            }

        }
    }

    @Override
    public void delete(String id) {
        Optional<MasterEvaluation> optional = evaluationDao.findById(id);
        Optional<MasterEvaReport> byId = evaReportDao.findById(id);

        if(optional.isPresent()){
            MasterEvaluation evaluation = optional.get();
            evaluation.setDel(1);
            evaluationDao.save(evaluation);
        }
        if(byId.isPresent()){
            MasterEvaReport evaReport = byId.get();
            evaReport.setDel(1);
            evaReportDao.save(evaReport);
        }
    }

    @Override
    public Page<MasterEvaluation> findSearch(Map searchMap, int page, int size) {
        Specification<MasterEvaluation> specification = createSpecification(searchMap);
        PageRequest pageRequest = PageRequest.of(page - 1, size, Sort.Direction.DESC, "createDate");
        return evaluationDao.findAll(specification, pageRequest);
    }

    @Override
    public MasterEvaluation findById(String id) {
        Optional<MasterEvaluation> evaluation = evaluationDao.findById(id);
        if (evaluation.isPresent()) {
            return evaluation.get();
        }
        return null;
    }

    @Override
    public MasterEvaluation findByName(String name) {
        MasterEvaluation evaluation = evaluationDao.findByUsernameAndMaxCreateDate(name);
        if (evaluation != null) {
            return evaluation;
        }
        return null;
    }

    /**
     * 动态条件构建
     *
     * @param searchMap
     * @return
     */
    private Specification<MasterEvaluation> createSpecification(Map searchMap) {

        return new Specification<MasterEvaluation>() {

            @Override
            public Predicate toPredicate(Root<MasterEvaluation> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                List<Predicate> predicateList = new ArrayList<Predicate>();
                if (searchMap.get("username") != null && !"".equals(searchMap.get("username"))) {
                    predicateList.add(cb.like(root.get("username").as(String.class), "%" + (String) searchMap.get("username") + "%"));
                }
                if (searchMap.get("projectName") != null && !"".equals(searchMap.get("projectName"))) {
                    predicateList.add(cb.like(root.get("projectName").as(String.class), "%" + (String) searchMap.get("projectName") + "%"));
                }

                return cb.and(predicateList.toArray(new Predicate[predicateList.size()]));

            }
        };

    }
}
