package com.zjty.inspect.utils;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.dao.MasterCoefficientModelDao;
import com.zjty.inspect.dao.MasterConfigParamDao;
import com.zjty.inspect.entity.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 获取预算
 * @author Mcj
 * @date 2020-02-26 15:14
 */

@Component
public class BudgetUitl {

    @Autowired
    private MasterConfigParamDao masterConfigParamDao;

    @Autowired
    private MasterCoefficientModelDao coefficientModelDao;

    /**
     * 获取预算数据
     * @param fund 技术费用
     * @param report
     * @param inspectParameter  计算所需数据
     * @return
     */
    public BudgetVo getBudget(Integer fund, ReportVo report, InspectParameter inspectParameter){

        BudgetVo budgetVo = new BudgetVo();

        // TODO: 2020-03-05 查询年复利率,查询修改，适配和重构占比
        List<MasterConfig> all = masterConfigParamDao.findAll();
        HashMap<Integer, String> doubleHashMap = new HashMap<>();
        for (MasterConfig config : all) {
            if(!doubleHashMap.containsKey(config.getType())){
                doubleHashMap.put(config.getType(),config.getValue());
            }
        }
        int scale;
        Integer systemFund = inspectParameter.getSystemFund();
        if(systemFund==0){
            double v = inspectParameter.getModules() * 7.5;
            systemFund= (int) v;
        }
        if(systemFund<=30){
            scale=1;
        }else if(systemFund<=2000){
            scale=2;
        }else{
            scale=3;
        }
        String s = doubleHashMap.get(1);
        if(StringUtils.isEmpty(s)) {
            inspectParameter.setMoneyRate(Double.valueOf(1.041));
        }else {
            inspectParameter.setMoneyRate(Double.valueOf(s));
        }
        Double moneyRate = inspectParameter.getMoneyRate();
        System.out.println(JSON.toJSONString("inspectParameter:"+inspectParameter));
        int year = inspectParameter.getYears();
        if(inspectParameter.getYears()==-1){
            year=1;
        }
        double pow = Math.pow(moneyRate, year);
        //带修正系数资金
        ArrayList<String> strings = new ArrayList<>();
        strings.add("安全能力");
        strings.add("容灾能力");
        strings.add("架构");
        strings.add("数据量");
        strings.add("模块数");
        strings.add("数据库表");
        strings.add("代码量");
        strings.add("内容");
        double coefficient = 1;
        List<MasterCoefficientModel> nameIn = coefficientModelDao.findAllByNameIn(strings);
        List<MasterCoefficientModel> collect = nameIn.stream().filter(a -> a.getScale() == scale).collect(Collectors.toList());
        for (MasterCoefficientModel model : collect) {
            CoefficientModelVo coefficientModelVo = new CoefficientModelVo();
            coefficientModelVo.setName(model.getName());
            if("架构".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getFramework());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }else if("容灾能力".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getDisaster());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("安全能力".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getSafety());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("数据量".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getData());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("模块数".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getModules());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            else if("数据库表".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getTables());
                coefficientModelVo.setValue(value);
                coefficient *=value;
            }
            else if("代码量".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getCodeSize());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }else if("内容".equals(model.getName())){
                Double value = model.countCoefficient(inspectParameter.getContent());
                coefficientModelVo.setValue(value);
                coefficient*=value;
            }
            budgetVo.getCoefficientModelVos().add(coefficientModelVo);
        }

        coefficient = BigDecimalUtil.get2precision(coefficient);

        if(inspectParameter.getRecastMethod()==1){
            //用户需要适配
            if(report.getRecastMethod()==1){
                String s1 = doubleHashMap.get(2);
                double refactorProportion1 = 0.6;
                if(!StringUtils.isEmpty(s1)){
                    refactorProportion1 = Double.parseDouble(doubleHashMap.get(2));
                }
                inspectParameter.setProportion(refactorProportion1);
                Budget budget1 = getCodeRefactor("代码重构预算", inspectParameter.getProportion(), pow, systemFund, fund, moneyRate, coefficient);
                budgetVo.getBudget().add(budget1);
                return budgetVo;
            }
            double refactorProportion=0.3;
            if(!StringUtils.isEmpty(doubleHashMap.get(4))){
                refactorProportion = Double.parseDouble(doubleHashMap.get(4));
            }

            inspectParameter.setProportion(refactorProportion);
            Budget budget = getCodeRefactor("代码修改预算", inspectParameter.getProportion(), pow, systemFund, fund, moneyRate, coefficient);
            budgetVo.getBudget().add(budget);
        }else{
            double refactorProportion=0.15;
            if(!StringUtils.isEmpty(doubleHashMap.get(3))){
                refactorProportion = Double.parseDouble(doubleHashMap.get(3));
            }
            inspectParameter.setProportion(refactorProportion);
            Budget budget = getCodeRefactor("代码适配预算", inspectParameter.getProportion(), pow, systemFund, fund, moneyRate, coefficient);
            budgetVo.getBudget().add(budget);
        }
        return budgetVo;
    }

    private Budget getCodeRefactor(String budgetName,double proportion,double pow,int systemFund,int fund,double moneyRate,double coefficient){
        Budget codeRefactor1 = new Budget();
        codeRefactor1.setProportion(proportion);
        codeRefactor1.setBudgetName(budgetName);
        codeRefactor1.setSysFund(systemFund);
        codeRefactor1.setMoneyRate(pow);
        codeRefactor1.setCoefficient(coefficient);
        double fundNotRepair1 = proportion * pow * systemFund;
        double fundRepair1=fundNotRepair1*coefficient;
        fundNotRepair1+=fund;
        fundRepair1+=fund;

        fundNotRepair1 = BigDecimalUtil.get2precision(fundNotRepair1);
        fundRepair1 = BigDecimalUtil.get2precision(fundRepair1);

        if(fundNotRepair1<fundRepair1){
            codeRefactor1.setFund(fundNotRepair1 +"--"+fundRepair1);
        }else if(fundNotRepair1>fundRepair1){
            codeRefactor1.setFund(fundRepair1 +"--"+fundNotRepair1);
        }else{
            codeRefactor1.setFund(fundRepair1 +"--"+fundNotRepair1);
        }
        codeRefactor1.setFundDetail("普通业务开发费用:"+fundNotRepair1);
        codeRefactor1.setFundDetail("普通业务开发费用(修正):"+fundRepair1);
        codeRefactor1.setFundDetail("关键适配技术成本:"+fund);
        return codeRefactor1;
    }
}
