package com.zjty.inspect.utils;

import com.alibaba.fastjson.JSON;
import com.zjty.inspect.entity.*;
import com.zjty.inspect.enums.*;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author Mcj
 * @date 2020-04-17 09:58
 */

public class WpsUtil {

    public static Map<String, Object> createWps(MasterEvaluation evaluation) {
        HashMap<String, List<TechnologyContent>> teMap = new HashMap<>();
        Reform reform = JSON.parseObject(evaluation.getInEva(), Reform.class);
        AssessmentReport assessmentReport = JSON.parseObject(evaluation.getOutEva(), AssessmentReport.class);
        Map keyValue = new HashMap<>();
        keyValue.put("username", reform.getUsername());
        keyValue.put("mode", RecastMethod.getByCode(assessmentReport.getRecastMethod()).getName());
        keyValue.put("projectName", reform.getProjectName());
        keyValue.put("codeUrl", reform.getCodeUrl());
        keyValue.put("codeName", reform.getCodeName());
        keyValue.put("gitUrl", reform.getGitUrl());
        keyValue.put("moduleNum", String.valueOf(reform.getModuleNum()));
        keyValue.put("cost", String.valueOf(reform.getCost()));
        keyValue.put("address", flipYesOrNo(reform.getAddress()));
        keyValue.put("localContact", reform.getLocalContact());
        keyValue.put("localPhone", reform.getLocalPhone());
        keyValue.put("secret", flipYesOrNo(reform.getSecret()));
        keyValue.put("disasterTolerance", flipYesOrNo(reform.getDisasterTolerance()));
        keyValue.put("safe", flipSafeStrong(reform.getSafe()));
        keyValue.put("framework", Framework.getByCode(reform.getFramework()).getName());
        for (int i = 0; i < reform.getApplicationType().size(); i++) {
            Integer code = reform.getApplicationType().get(i);
            keyValue.put("applicationType" + i + 1, ApplicationType.getByCode(code).getName());
        }
        keyValue.put("time", String.valueOf(reform.getTime()));
        if(StringUtils.isEmpty(String.valueOf(reform.getTime()))){
            keyValue.put("time", "0");
        }

        keyValue.put("tableNum", "0");
        if(!StringUtils.isEmpty(String.valueOf(reform.getTableNum()))){
            keyValue.put("tableNum", String.valueOf(reform.getTableNum()));
        }
        keyValue.put("databaseNum", String.valueOf(reform.getDatabaseNum()));
        keyValue.put("strategy", strategyToString(reform.getStrategy()));
        keyValue.put("rto", RtoEnum.getByCode(reform.getRto()).getName());
        keyValue.put("rpo", RpoEnum.getByCode(reform.getRpo()).getName());
        keyValue.put("unitName","无");
        if(!StringUtils.isEmpty(reform.getUnitName())){
            keyValue.put("unitName",reform.getUnitName() );
        }


        keyValue.put("unitPhone", reform.getUnitPhone());
        keyValue.put("unitContent", reform.getUnitContent());
        keyValue.put("gradeProtection", flipYesOrNo(reform.getGradeProtection()));
        keyValue.put("cycle", String.valueOf(reform.getCycle()));
        if(reform.getCycle()==null){
            keyValue.put("cycle","0" );
        }

        SystemStructure systemStructure = reform.getSystemStructure();
        Details application = systemStructure.getApplication();
        getSys("application", application, keyValue);
        Details database = systemStructure.getDatabase();
        getSys("database", database, keyValue);

        Details nas = systemStructure.getNas();
        getSys("nas", nas, keyValue);

        Details slb = systemStructure.getSlb();
        getSys("slb", slb, keyValue);

        Details cdn = systemStructure.getCdn();
        getSys("cdn", cdn, keyValue);

        Details vps = systemStructure.getVps();
        getSys("vps", vps, keyValue);

        Browser browser = reform.getBrowser();

        repairMap("compatibleBrowsers", 13, browser.getCompatibleBrowsers(), keyValue);
        repairMap("browserPlugs", 13, browser.getBrowserPlugs(), keyValue);
        repairMap("middleware", 13, reform.getMiddleware().getMiddlewareEnums(), keyValue);
        Middleware middleware = reform.getMiddleware();
        List<OtherApi> otherApis = middleware.getOtherApis();
        for (int i = 0; i < 13; i++) {
            int i1 = i + 1;
            if (i >= otherApis.size()) {
                keyValue.put("otherApi" + i1, "无");
                continue;
            }
            keyValue.put("otherApi" + i1, otherApis.get(i).getApiName());
        }
        repairMap("microService", 13, middleware.getMicroServices(), keyValue);


        Database database1 = reform.getDatabase();
        for (int i = 0; i < 13; i++) {
            int i1 = i + 1;
            if (i >= database1.getDatabaseType().size()) {
                keyValue.put("database" + i1, "无");
                continue;
            }
            keyValue.put("database" + i1, database1.getDatabaseType().get(i).getName());
        }


        keyValue.put("databaseView", flipYesOrNo(database1.getView()));
        keyValue.put("databaseStorage", flipYesOrNo(database1.getStorage()));
        keyValue.put("databaseFunction", flipYesOrNo(database1.getFunction()));
        keyValue.put("databaseDbLink", flipYesOrNo(database1.getDbLink()));
        keyValue.put("databaseTimeTask", flipYesOrNo(database1.getTimeTask()));
        keyValue.put("databaseSequence", flipYesOrNo(database1.getSequence()));
        keyValue.put("databaseTrigger", flipYesOrNo(database1.getTrigger()));
        keyValue.put("databaseSafe", flipYesOrNo(database1.getSafe()));
        keyValue.put("databaseDisasterTolerance", flipYesOrNo(database1.getDisasterTolerance()));
        keyValue.put("databaseSeparate", flipYesOrNo(database1.getSeparate()));
        keyValue.put("databasePerformance", flipYesOrNo(database1.getPerformance()));
        keyValue.put("databaseOtherContent", database1.getOtherContent());
        keyValue.put("recastMethod",RecastMethod.getByCode(assessmentReport.getRecastMethod()));
        Apply apply = reform.getApply();
        keyValue.put("applyCost", String.valueOf(apply.getCost()));
        if(StringUtils.isEmpty(String.valueOf(apply.getCost()))||apply.getCost()==-1) {
            keyValue.put("applyCost", "0");
        }
        if(!StringUtils.isEmpty(apply.getReason())&&apply.getReason().equals("-1")) {
            keyValue.put("applyReason","无");
        }else {
            keyValue.put("applyReason",apply.getReason());
        }

        DevelopLanguageSystem developLanguageSystem = reform.getDevelopLanguageSystem();
        if(!"".equals(developLanguageSystem.getName())){
            keyValue.put("language", developLanguageSystem.getName());
        }else{
            keyValue.put("language",LanguageEnum.getByCode(assessmentReport.getLanguage()).getName());
        }
        repairMap("devFrameworks", 13, developLanguageSystem.getDevFrameworks(), keyValue);
        repairMap("fontDevTechnologies", 13, developLanguageSystem.getFontDevTechnologies(), keyValue);
        repairMap("csDevTechnologies", 13, developLanguageSystem.getCsDevTechnologies(), keyValue);
        repairMap("opGAs", 13, developLanguageSystem.getOpGAs(), keyValue);
        if(!developLanguageSystem.getDevLanguages().isEmpty()){
            repairMap("devLanguages", 13, developLanguageSystem.getDevLanguages(), keyValue);
        }else{
            List<Integer> languages = assessmentReport.getLanguages();
            ArrayList<BaseDes> list = new ArrayList<>();
            for (Integer language : languages) {
                BaseDes baseDes = new BaseDes();
                baseDes.setName(LanguageEnum.getByCode(language).getName());
                baseDes.setCode(language);
                list.add(baseDes);
            }
            repairMap("devLanguages", 13, list, keyValue);
        }

        LocalSystemDep localSystemDep = reform.getLocalSystemDep();
        keyValue.put("localSystemDepName", localSystemDep.getName());
        keyValue.put("localSystemDepMoney", String.valueOf(localSystemDep.getMoney()));
        keyValue.put("localSystemDepDes", localSystemDep.getDes());

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = simpleDateFormat.format(assessmentReport.getTime());
        keyValue.put("inspectTime", format);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String f = sdf.format(assessmentReport.getTime());
        keyValue.put("createTime", f);
        keyValue.put("difficulty", String.valueOf(assessmentReport.getDifficulty()));
        keyValue.put("budget", assessmentReport.getBudget());

        SysScale sysScale = assessmentReport.getSysScale();
        if(sysScale.getCode().getNum()==-1) {
            keyValue.put("sysScaleCodeNum", "0");
        }else{
            keyValue.put("sysScaleCodeNum", sysScale.getCode().getNum());
        }
        keyValue.put("sysScaleCodeDes", sysScale.getCode().getDes());

        keyValue.put("sysScaleFileNum", sysScale.getFile().getNum());
        keyValue.put("sysScaleFileDes", sysScale.getFile().getDes());

        keyValue.put("sysScaleModeNum", sysScale.getMode().getNum());
        keyValue.put("sysScaleModeDes", sysScale.getMode().getDes());

        TechnologyList technologyList = assessmentReport.getTechnologyList();
        keyValue.put("technologyDes", technologyList.getDes());
        List<TechnologyReport> technologyReports = technologyList.getTechnologyReports();
//        for (int i = 0; i < technologyList.getTechnologyReports().size(); i++) {
//            int i2 = i + 1;
//            keyValue.put("technology" + i2, technologyReports.get(i).getTechnology());
//            for (int i1 = 0; i1 < technologyReports.get(i).getTechnologyContents().size(); i1++) {
//                int i3 = i1 + 1;
//                TechnologyContent technologyContent = technologyReports.get(i).getTechnologyContents().get(i1);
//                keyValue.put("technologyContentLocal" + i2 + "-" + i3, technologyContent.getLocal());
//                keyValue.put("technologyContentKeyWord" + i2 + "-" + i3, technologyContent.getKeyWord());
//                keyValue.put("technologyContentFile" + i2 + "-" + i3, technologyContent.getFile());
//                keyValue.put("technologyContentPosition" + i2 + "-" + i3, technologyContent.getPosition());
//                keyValue.put("technologyContentStrategy" + i2 + "-" + i3, getMode(technologyContent.getStrategy()));
//            }
//        }
        HashMap<String, List<TechnologyContent>> yhMap = new HashMap<>();
        HashMap<String, List<TechnologyContent>> nsMap = new HashMap<>();
        HashMap<String, List<TechnologyContent>> wzMap = new HashMap<>();
        for (TechnologyReport technologyReport : technologyReports) {
            if(technologyReport.getTechnology().contains("优化")){
                yhMap.put(technologyReport.getTechnology(), technologyReport.getTechnologyContents());
            }else if(technologyReport.getTechnology().contains("不支持")) {
                nsMap.put(technologyReport.getTechnology(), technologyReport.getTechnologyContents());
            }else if(technologyReport.getTechnology().contains("未知")){
                wzMap.put(technologyReport.getTechnology(), technologyReport.getTechnologyContents());
            }
        }
        keyValue.put("yh",yhMap);
        keyValue.put("ns",nsMap);
        keyValue.put("wz",wzMap);

        Workload workload = assessmentReport.getWorkload();
        keyValue.put("workloadDes", workload.getDes());
        keyValue.put("workloadCost", String.valueOf(workload.getCost()));
        keyValue.put("workloadMode", String.valueOf(workload.getMode()));

        Basis development = workload.getDevelopment();
        keyValue.put("workloadDevelopmentVolume", String.valueOf(development.getDevelopmentVolume()));
        keyValue.put("workloadDevelopmentCorrectionFactor", String.valueOf(development.getCorrectionFactor()));

        Basis test = workload.getTest();
        keyValue.put("workloadTestVolume", String.valueOf(test.getDevelopmentVolume()));
        keyValue.put("workloadTestCorrectionFactor", String.valueOf(test.getCorrectionFactor()));

        Basis deploy = workload.getDeploy();
        keyValue.put("workloadDeployVolume", String.valueOf(deploy.getDevelopmentVolume()));
        keyValue.put("workloadDeployCorrectionFactor", String.valueOf(deploy.getCorrectionFactor()));
        double correctionFactor = development.getCorrectionFactor();
        double correctionFactor1 = test.getCorrectionFactor();
        double correctionFactor2 = deploy.getCorrectionFactor();
        BigDecimal bigDecimal = BigDecimal.valueOf(correctionFactor);
        BigDecimal bigDecima2 = BigDecimal.valueOf(correctionFactor1);
        BigDecimal bigDecima3 = BigDecimal.valueOf(correctionFactor2);
        double v = bigDecimal.add(bigDecima2).add(bigDecima3).doubleValue();
        Basis total = workload.getTotal();
        String correction = new DecimalFormat("0.000").format(v);
        keyValue.put("workloadTotalVolume", String.valueOf(total.getDevelopmentVolume()));
        keyValue.put("workloadTotalCorrectionFactor", correction);

        DifficultyAssessment difficultyAssessment = assessmentReport.getDifficultyAssessment();
        keyValue.put("difficultyAssessmentDes", difficultyAssessment.getDes());
        FrameDifficulty frameDifficulty = difficultyAssessment.getFrameDifficulty();
        keyValue.put("difficultyDifficultySystemEvaluation", String.valueOf(frameDifficulty.getSystemEvaluation()));
        keyValue.put("difficultyDifficultyMessage", String.valueOf(frameDifficulty.getMessage()));
        keyValue.put("difficultyDifficultyDifficulty", String.valueOf(frameDifficulty.getDifficulty()));
        keyValue.put("difficultyDifficultyLoad", String.valueOf(frameDifficulty.getLoad()));
        keyValue.put("difficultyDifficultyDetails", Framework.getByCode(frameDifficulty.getDetails()).getName());
        keyValue.put("difficultyDifficultyDistributed", flipYesOrNo(frameDifficulty.getDistributed()));
        keyValue.put("difficultyDifficultyLoadBalance", flipYesOrNo(frameDifficulty.getLoadBalance()));
        keyValue.put("difficultyDifficultyDisaster", flipYesOrNo(frameDifficulty.getDisaster()));
        keyValue.put("difficultyDifficultyOtherDemand", frameDifficulty.getOtherDemand());

        BrowserDifficulty browserDifficulty = difficultyAssessment.getBrowserDifficulty();
        keyValue.put("browserDifficultySystemEvaluation", String.valueOf(browserDifficulty.getSystemEvaluation()));
        keyValue.put("browserDifficultyMessage", String.valueOf(browserDifficulty.getMessage()));
        keyValue.put("browserDifficultyDifficulty", String.valueOf(browserDifficulty.getDifficulty()));
        keyValue.put("browserDifficultyLoad", String.valueOf(browserDifficulty.getLoad()));
        keyValue.put("browserDifficultyStyle", flipYesOrNo(browserDifficulty.getStyle()));
        keyValue.put("browserDifficultyApi", flipYesOrNo(browserDifficulty.getApi()));
        keyValue.put("browserDifficultyPlugInUnit", flipYesOrNo(browserDifficulty.getPlugInUnit()));
        keyValue.put("browserDifficultyGeography", flipYesOrNo(browserDifficulty.getGeography()));
        keyValue.put("browserDifficultyPeripheral", flipYesOrNo(browserDifficulty.getPeripheral()));
        keyValue.put("browserDifficultyAnimation", flipYesOrNo(browserDifficulty.getAnimation()));
        keyValue.put("browserDifficultyThreeD", flipYesOrNo(browserDifficulty.getThreeD()));
        keyValue.put("browserDifficultyDocument", flipYesOrNo(browserDifficulty.getDocument()));
        keyValue.put("browserDifficultyMedia", flipYesOrNo(browserDifficulty.getMedia()));
        keyValue.put("browserDifficultyFlash", flipYesOrNo(browserDifficulty.getFlash()));
        keyValue.put("browserDifficultyOtherDemand", flipYesOrNo(browserDifficulty.getOtherDemand()));

        MiddlewareDifficulty middlewareDifficulty = difficultyAssessment.getMiddlewareDifficulty();
        keyValue.put("middlewareDifficultySystemEvaluation", String.valueOf(middlewareDifficulty.getSystemEvaluation()));
        keyValue.put("middlewareDifficultyMessage", String.valueOf(middlewareDifficulty.getMessage()));
        keyValue.put("middlewareDifficultyDifficulty", String.valueOf(middlewareDifficulty.getDifficulty()));
        keyValue.put("middlewareDifficultyLoad", String.valueOf(middlewareDifficulty.getLoad()));
        keyValue.put("middlewareDifficultyNumber", String.valueOf(middlewareDifficulty.getNumber()));
        keyValue.put("middlewareDifficultyWeb", flipYesOrNo(middlewareDifficulty.getWeb()));
        keyValue.put("middlewareDifficultyJndi", flipYesOrNo(middlewareDifficulty.getJndi()));
        keyValue.put("middlewareDifficultyJms", flipYesOrNo(middlewareDifficulty.getJms()));
        keyValue.put("middlewareDifficultyRoute", flipYesOrNo(middlewareDifficulty.getRoute()));

        DatabaseDifficulty databaseDifficulty = difficultyAssessment.getDatabaseDifficulty();
        keyValue.put("databaseDifficultyDifficulty", String.valueOf(databaseDifficulty.getDifficulty()));
        keyValue.put("databaseDifficultyLoad", String.valueOf(databaseDifficulty.getLoad()));
        keyValue.put("databaseDisasterTolerance", getDis(databaseDifficulty.getDisasterTolerance()));
        keyValue.put("databaseDifficultySafe", flipYesOrNo(databaseDifficulty.getSafe()));
        keyValue.put("databaseDifficultySeparate", flipYesOrNo(databaseDifficulty.getSeparate()));
        keyValue.put("databaseDifficultyPerformance", flipYesOrNo(databaseDifficulty.getPerformance()));

        ProgramDifficulty programDifficulty = difficultyAssessment.getProgramDifficulty();
        keyValue.put("programDifficultyDifficulty", String.valueOf(programDifficulty.getDifficulty()));
        keyValue.put("programDifficultyLoad", String.valueOf(programDifficulty.getLoad()));

        return keyValue;
    }

    public static DocumentContent setDocumentTable(List<String> data, int col) {
//        String tableString = DocumentWordUtil.getTableString(data, col);
//        DocumentContent documentContent = new DocumentContent();
//        设置进head标题下面的表格中
//        documentContent.setDocumentTable(tableString);
        return null;
    }

    public static List<DocumentContent> setDocumentContents(DocumentContent documentContent) {
        ArrayList<DocumentContent> documentContents = new ArrayList<>();
        documentContents.add(documentContent);
        return documentContents;
    }

    private static int getFramework(String construction) {
        switch (construction) {
            case "B/S":
                return 1;
            case "C/S":
                return 2;
            case "单机运行":
                return 0;
            case "分布式":
                return 4;
        }
        return -1;
    }

    private static String getFilpFramework(int construction) {
        switch (construction) {
            case 1:
                return "B/S";
            case 2:
                return "C/S";
            case 0:
                return "单机运行";
            case 4:
                return "分布式";
            default:
                break;
        }
        return "";
    }

    private static int yesOrNo(String target) {
        if ("是".equals(target)) {
            return 1;
        } else if ("否".equals(target)) {
            return 2;
        } else {
            return -1;
        }
    }

    private static int SpecialYesOrNo(String target) {
        if ("是".equals(target)) {
            return 4;
        } else if ("否".equals(target)) {
            return 0;
        } else {
            return -1;
        }
    }

    private static String flipYesOrNo(Integer target) {
        if (target == 1) {
            return "是";
        } else if (target == 2) {
            return "否";
        } else {
            return "我不清楚";
        }
    }

    private static String flipSafeYesOrNo(Integer target) {
        if (target == null) {
            return "否";
        }
        if (target == 4) {
            return "强";
        } else if (target == 2) {
            return "弱";
        } else {
            return "我不清楚";
        }
    }

    private static String flipSpecialYesOrNo(Integer target) {
        if (target == 4) {
            return "是";
        } else if (target == 0) {
            return "否";
        } else {
            return "我不清楚";
        }
    }

    private static String getMode(Integer target) {
        if (target == null) {
            return "我不清楚";
        }
        if (target == 1) {
            return "改造";
        } else if (target == 2) {
            return "适配";
        } else {
            return "我不清楚";
        }
    }

    private static String flipSafeStrong(Integer target) {
        if (target == null || target == 1) {
            return "无";
        }
        if (target == 3) {
            return "强";
        } else if (target == 2) {
            return "弱";
        } else {
            return "我不清楚";
        }
    }

    private static String strategyToString(Integer target) {
        if (target == 1) {
            return "休息日或晚间切换";
        } else if (target == 2) {
            return "暂停服务";
        } else if (target == 3) {
            return "平滑过渡";
        } else {
            return "不清楚";
        }
    }

    private static String localOrCloud(Integer deploy) {
        if (deploy == 1) {
            return "本地";
        } else if (deploy == 2) {
            return "政务云";
        } else {
            return "不清楚";
        }
    }

    private static String getDis(Integer dis) {
        if (dis == 1) {
            return "否";
        } else if (dis == 2) {
            return "主备";
        } else if (dis == 3) {
            return "分布式";
        } else {
            return "不清楚";
        }
    }

    private static void getSys(String sysName, Details application, Map<String, String> keyValue) {
        keyValue.put(sysName + "Deploy", localOrCloud(application.getDeploy()));
        keyValue.put(sysName + "OperateSystem", application.getOperateSystem().getName());
        keyValue.put(sysName + "Code", String.valueOf(application.getOperateSystem().getCode()));
        keyValue.put(sysName + "Num", application.getNum());
        keyValue.put(sysName + "CpuNum", application.getCpuNum());
        keyValue.put(sysName + "Ghz", application.getGhz());
        keyValue.put(sysName + "Space", application.getSpace());
        keyValue.put(sysName + "Other", application.getSpace());
        keyValue.put(sysName + "Edition", application.getEdition());
        keyValue.put(sysName + "Memory", application.getMemory());
    }

    private static void repairMap(String name, int size, List<BaseDes> list, Map<String, String> keyValue) {
        if (list != null && list.size() > 0) {
            int len = list.size();
            for (int i = 0; i < size; i++) {
                int i1 = i + 1;
                if (len > i) {
                    if (!StringUtils.isEmpty(list.get(i).getName())) {
                        if(!StringUtils.isEmpty(list.get(i).getDes())){
                            keyValue.put(name + i1, list.get(i).getDes());
                        }else{
                            keyValue.put(name + i1, list.get(i).getName());
                        }
                    } else {
                        keyValue.put(name + i1, "无");
                    }
                } else {
                    keyValue.put(name + i1, "无");
                }

            }
        } else {
            for (int i = 0; i < size; i++) {
                int i1 = i + 1;
                keyValue.put(name + i1, "无");
            }
        }
    }
}
