package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * <h4>Description : 数据库难度</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 19:36
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "数据库难度")
public class DatabaseDifficulty {
    /**
     * 系统评估
     */
    //private double systemEvaluation = 1.1;

    /**
     * 额外信息
     */
    //private double message = 1.1;

    /**
     * 综合难度
     */
    private double difficulty;

    /**
     * 工作量
     */
    private double load = 0.0;

    /**
     * 依赖
     */
    private List<DependOnNum> dependOnNum = new ArrayList<>();

    /**
     * 容灾 （1：否 2：主备 3：分布式）
     */
    @ApiModelProperty(value = "容灾 （1：否 2：主备 3：分布式）",example = "1")
    private Integer disasterTolerance;

    /**
     * 安全 1：是 2：否
     */
    @ApiModelProperty(value = "安全 1：是 2：否",example = "1")
    private Integer safe;

    /**
     * 读写分离 1：是 2：否
     */
    @ApiModelProperty(value = "读写分离 1：是 2：否",example = "1")
    private Integer separate;

    /**
     * 更高性能 1：是 2：否
     */
    @ApiModelProperty(value = "更高性能 1：是 2：否",example = "1")
    private Integer performance;

    /**
     * 其他内容
     */
    private String otherContent;
}
