package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Id;

/**
 * 传入参数表
 * @author Mcj
 * @date 2020-02-12 12:35
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@ApiModel(value = "传入参数表")
public class InspectParameter {

    @Id
    private String id;

    /**
     * 用户名
     */
    private String username;
    /**
     *  重构占比
     */
    private Double proportion;

    /**
     * 年利率
     */
    private Double moneyRate;

    /**
     * 软件开发时间
     */
    @ApiModelProperty(value = "软件开发时间",example = "1")
    private Integer years;

    /**
     * 原系统费用
     */
    @ApiModelProperty(value = "原系统费用",example = "1")
    private Integer systemFund;

    /**
     * 模块数
     */
    @ApiModelProperty(value = "模块数",example = "1")
    private Integer modules;

    /**
     * 数据量
     */
    @ApiModelProperty(value = "数据量",example = "1")
    private Integer data;

    /**
     * 代码量
     */
    @ApiModelProperty(value = "代码量",example = "1")
    private Integer codeSize;

    /**
     * 内容
     */
    @ApiModelProperty(value = "内容",example = "1")
    private Integer content;
    /**
     * 架构
     */
    @ApiModelProperty(value = "架构",example = "1")
    private Integer framework;

    /**
     * 数据库表数量
     */
    @ApiModelProperty(value = "数据库表数量",example = "1")
    private Integer tables;

    /**
     * 安全能力
     * 0：无
     * 2：弱
     * 4：强
     */
    @ApiModelProperty(value = "安全能力",example = "0")
    private Integer safety;

    /**
     * 容灾
     * 0：无0，有+0.05
     * 2：有0，无-0.05
     * 4：有0，无-0.1
     */
    @ApiModelProperty(value = "容灾",example = "2")
    private Integer disaster;

    /**
     * null:无效
     */
    private String valid;

    /**
     * 评估报告地址
     */
    private String reportAddress;

    /**
     * git上传地址
     */
    private String gitAddress;

    /**
     * 项目名称
     */
    private String gitName;

    /**
     * 源代码存储地址
     */
    private String sourceAddress;

    /**
     * 是否管理员
     * 1:是
     * 0:否
     */
    @ApiModelProperty(value = "是否管理员",example = "1")
    private Integer admin;

    /**
     * 方式
     * 1：修改
     * 2：适配：
     */
    @ApiModelProperty(value = "方式",example = "1")
    private Integer recastMethod;

    /**
     * 报告id
     */
    private String reportId;
}
