package com.zjty.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.multipart.MultipartFile;

@ApiModel("大文件分片入参实体")
public class MultipartFileParam {
  @ApiModelProperty("文件传输任务ID")
  private String taskId;

  @ApiModelProperty("当前为第几分片")
  private int chunkNumber;

  @ApiModelProperty("每个分块的大小")
  private long chunkSize;


  @ApiModelProperty("分片总数")
  private int totalChunks;
  @ApiModelProperty("文件唯一标识")
  private String identifier;


  @ApiModelProperty("分块文件传输对象")
  private MultipartFile file;

  public String getTaskId() {
    return taskId;
  }

  public void setTaskId(String taskId) {
    this.taskId = taskId;
  }

  public int getChunkNumber() {
    return chunkNumber;
  }

  public void setChunkNumber(int chunkNumber) {
    this.chunkNumber = chunkNumber;
  }

  public long getChunkSize() {
    return chunkSize;
  }

  public void setChunkSize(long chunkSize) {
    this.chunkSize = chunkSize;
  }

  public int getTotalChunks() {
    return totalChunks;
  }

  public void setTotalChunks(int totalChunks) {
    this.totalChunks = totalChunks;
  }

  public MultipartFile getFile() {
    return file;
  }

  public void setFile(MultipartFile file) {
    this.file = file;
  }

  public String getIdentifier() {
    return identifier;
  }

  public void setIdentifier(String identifier) {
    this.identifier = identifier;
  }
}